/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.contract.execution.impl;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperledger.fabric.contract.execution.InvocationRequest;
import org.hyperledger.fabric.shim.ChaincodeStub;

public final class ContractInvocationRequest
implements InvocationRequest {
    private static final Log LOGGER = LogFactory.getLog(ContractInvocationRequest.class);
    private static final Pattern NS_REGEX = Pattern.compile(":");
    private final String namespace;
    private final String method;
    private final List<byte[]> args;

    public ContractInvocationRequest(ChaincodeStub context) {
        List<byte[]> funcAndArgs = context.getArgs();
        if (funcAndArgs.isEmpty()) {
            throw new IllegalArgumentException("Missing function name");
        }
        String func = new String(funcAndArgs.get(0), StandardCharsets.UTF_8);
        LOGGER.debug((Object)func);
        String[] funcParts = NS_REGEX.split(func);
        if (funcParts.length == 2) {
            this.namespace = funcParts[0];
            this.method = funcParts[1];
        } else {
            this.namespace = "default";
            this.method = funcParts[0];
        }
        this.args = funcAndArgs.subList(1, funcAndArgs.size());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(this.namespace + " " + this.method + " " + String.valueOf(this.args)));
        }
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public List<byte[]> getArgs() {
        return this.args;
    }

    @Override
    public String getRequestName() {
        return this.namespace + ":" + this.method;
    }

    public String toString() {
        return this.namespace + ":" + this.method + " @" + Integer.toHexString(System.identityHashCode(this));
    }
}

