/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.contract.execution;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import org.hyperledger.fabric.Logger;
import org.hyperledger.fabric.contract.ContractRuntimeException;
import org.hyperledger.fabric.contract.annotation.Serializer;
import org.hyperledger.fabric.contract.execution.SerializerInterface;
import org.hyperledger.fabric.contract.metadata.TypeSchema;
import org.hyperledger.fabric.contract.routing.DataTypeDefinition;
import org.hyperledger.fabric.contract.routing.PropertyDefinition;
import org.hyperledger.fabric.contract.routing.TypeRegistry;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Serializer
public class JSONTransactionSerializer
implements SerializerInterface {
    private static final Logger LOGGER = Logger.getLogger(JSONTransactionSerializer.class.getName());
    private final TypeRegistry typeRegistry = TypeRegistry.getRegistry();

    @Override
    public byte[] toBuffer(Object value, TypeSchema ts) {
        LOGGER.debug(() -> "Schema to convert is " + String.valueOf(ts));
        byte[] buffer = null;
        if (value != null) {
            String type = ts.getType();
            if (type != null) {
                switch (type) {
                    case "array": {
                        JSONArray array = this.normalizeArray(new JSONArray(value), ts);
                        buffer = array.toString().getBytes(StandardCharsets.UTF_8);
                        break;
                    }
                    case "string": {
                        String format = ts.getFormat();
                        if ("utin16".equals(format)) {
                            buffer = Character.valueOf(((Character)value).charValue()).toString().getBytes(StandardCharsets.UTF_8);
                            break;
                        }
                        buffer = ((String)value).getBytes(StandardCharsets.UTF_8);
                        break;
                    }
                    default: {
                        buffer = value.toString().getBytes(StandardCharsets.UTF_8);
                        break;
                    }
                }
            } else {
                DataTypeDefinition dtd = this.typeRegistry.getDataType(ts);
                Set<String> keySet = dtd.getProperties().keySet();
                String[] propNames = keySet.toArray(new String[0]);
                JSONObject obj = new JSONObject(new JSONObject(value), propNames);
                buffer = obj.toString().getBytes(StandardCharsets.UTF_8);
            }
        }
        return buffer;
    }

    private JSONArray normalizeArray(JSONArray jsonArray, TypeSchema ts) {
        JSONArray normalizedArray;
        TypeSchema items = ts.getItems();
        String type = items.getType();
        if (null == type) {
            DataTypeDefinition dtd = this.typeRegistry.getDataType(items);
            Set<String> keySet = dtd.getProperties().keySet();
            String[] propNames = keySet.toArray(new String[0]);
            normalizedArray = new JSONArray();
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject obj = new JSONObject(jsonArray.getJSONObject(i), propNames);
                normalizedArray.put(i, (Object)obj);
            }
        } else if ("array".equals(type)) {
            normalizedArray = new JSONArray();
            for (int i = 0; i < jsonArray.length(); ++i) {
                normalizedArray.put(i, (Object)this.normalizeArray(jsonArray.getJSONArray(i), items));
            }
        } else {
            normalizedArray = jsonArray;
        }
        return normalizedArray;
    }

    @Override
    public Object fromBuffer(byte[] buffer, TypeSchema ts) {
        try {
            String stringData = new String(buffer, StandardCharsets.UTF_8);
            return this.convert(stringData, ts);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ContractRuntimeException(e);
        }
    }

    private Class<?> mapPrimitive(Class<?> primitive) {
        if (primitive.isArray()) {
            return this.mapArrayPrimitive(primitive);
        }
        return this.mapBasicPrimitive(primitive);
    }

    private Class<?> mapArrayPrimitive(Class<?> primitive) {
        switch (primitive.getComponentType().getName()) {
            case "int": {
                return Integer[].class;
            }
            case "long": {
                return Long[].class;
            }
            case "float": {
                return Float[].class;
            }
            case "double": {
                return Double[].class;
            }
            case "short": {
                return Short[].class;
            }
            case "byte": {
                return Byte[].class;
            }
            case "char": {
                return Character[].class;
            }
            case "boolean": {
                return Boolean[].class;
            }
        }
        return primitive;
    }

    private Class<?> mapBasicPrimitive(Class<?> primitive) {
        switch (primitive.getName()) {
            case "int": {
                return Integer.class;
            }
            case "long": {
                return Long.class;
            }
            case "float": {
                return Float.class;
            }
            case "double": {
                return Double.class;
            }
            case "short": {
                return Short.class;
            }
            case "byte": {
                return Byte.class;
            }
            case "char": {
                return Character.class;
            }
            case "boolean": {
                return Boolean.class;
            }
        }
        return primitive;
    }

    private Object convert(String stringData, TypeSchema ts) throws IllegalAccessException, InstantiationException {
        LOGGER.debug(() -> "Schema to convert is " + String.valueOf(ts));
        String type = ts.getType();
        String format = null;
        if (type == null) {
            type = "object";
            String ref = ts.getRef();
            format = ref.substring(ref.lastIndexOf(47) + 1);
        }
        switch (type) {
            case "string": {
                return this.convertString(stringData, ts);
            }
            case "integer": {
                return this.convertInteger(stringData, ts);
            }
            case "number": {
                return this.convertNumber(stringData, ts);
            }
            case "boolean": {
                return Boolean.parseBoolean(stringData);
            }
            case "object": {
                return this.createComponentInstance(format, stringData, ts);
            }
            case "array": {
                return this.convertArray(stringData, ts);
            }
        }
        return null;
    }

    private Object convertArray(String stringData, TypeSchema ts) throws IllegalAccessException, InstantiationException {
        JSONArray jsonArray = new JSONArray(stringData);
        TypeSchema itemSchema = ts.getItems();
        Object[] data = (Object[])Array.newInstance(this.mapPrimitive(itemSchema.getTypeClass(this.typeRegistry)), jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            Object convertedData;
            data[i] = convertedData = this.convert(jsonArray.get(i).toString(), itemSchema);
        }
        return data;
    }

    private Object convertNumber(String stringData, TypeSchema ts) {
        if ("float".equals(ts.getFormat())) {
            return Float.valueOf(Float.parseFloat(stringData));
        }
        return Double.parseDouble(stringData);
    }

    private Object convertInteger(String stringData, TypeSchema ts) {
        switch (ts.getFormat()) {
            case "int32": {
                return Integer.parseInt(stringData);
            }
            case "int8": {
                return Byte.parseByte(stringData);
            }
            case "int16": {
                return Short.parseShort(stringData);
            }
            case "int64": {
                return Long.parseLong(stringData);
            }
        }
        throw new IllegalArgumentException("Unknown format for integer " + ts.getFormat());
    }

    private Object convertString(String stringData, TypeSchema ts) {
        if ("uint16".equals(ts.getFormat())) {
            return Character.valueOf(stringData.charAt(0));
        }
        return stringData;
    }

    Object createComponentInstance(String format, String jsonString, TypeSchema ts) {
        Object obj;
        DataTypeDefinition dtd = this.typeRegistry.getDataType(format);
        try {
            obj = dtd.getTypeClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e1) {
            throw new ContractRuntimeException("Unable to to create new instance of type", e1);
        }
        JSONObject json = new JSONObject(jsonString);
        ts.validate(json);
        try {
            Map<String, PropertyDefinition> fields = dtd.getProperties();
            for (PropertyDefinition prop : fields.values()) {
                Field f = prop.getField();
                f.setAccessible(true);
                Object newValue = this.convert(json.get(prop.getName()).toString(), prop.getSchema());
                f.set(obj, newValue);
            }
            return obj;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | JSONException e) {
            throw new ContractRuntimeException("Unable to convert JSON to object", e);
        }
    }
}

