/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.shim.ledger;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.hyperledger.fabric.shim.ledger.CompositeKeyFormatException;

public class CompositeKey {
    private static final String DELIMITER = new String(Character.toChars(0));
    private static final String INVALID_SEGMENT_CHAR = new String(Character.toChars(0x10FFFF));
    private static final String INVALID_SEGMENT_PATTERN = String.format("(?:%s|%s)", INVALID_SEGMENT_CHAR, DELIMITER);
    public static final String NAMESPACE = DELIMITER;
    private final String objectType;
    private final List<String> attributes;
    private final String compositeKey;

    public CompositeKey(String objectType, String ... attributes) {
        this(objectType, attributes == null ? Collections.emptyList() : Arrays.asList(attributes));
    }

    public CompositeKey(String objectType, List<String> attributes) {
        if (objectType == null) {
            throw new NullPointerException("objectType cannot be null");
        }
        this.objectType = objectType;
        this.attributes = attributes;
        this.compositeKey = this.generateCompositeKeyString(objectType, attributes);
    }

    public String getObjectType() {
        return this.objectType;
    }

    public List<String> getAttributes() {
        return this.attributes;
    }

    public String toString() {
        return this.compositeKey;
    }

    public static CompositeKey parseCompositeKey(String compositeKey) {
        if (compositeKey == null) {
            return null;
        }
        if (!compositeKey.startsWith(NAMESPACE)) {
            throw CompositeKeyFormatException.forInputString(compositeKey, compositeKey, 0);
        }
        String[] segments = compositeKey.split(DELIMITER, 0);
        return new CompositeKey(segments[1], (String[])Arrays.stream(segments).skip(2L).toArray(String[]::new));
    }

    public static void validateSimpleKeys(String ... keys) {
        for (String key : keys) {
            if (key.isEmpty() || !key.startsWith(NAMESPACE)) continue;
            throw CompositeKeyFormatException.forSimpleKey(key);
        }
    }

    private String generateCompositeKeyString(String objectType, List<String> attributes) {
        this.validateCompositeKeySegment(objectType);
        if (attributes == null || attributes.isEmpty()) {
            return NAMESPACE + objectType + DELIMITER;
        }
        attributes.forEach(this::validateCompositeKeySegment);
        return attributes.stream().collect(Collectors.joining(DELIMITER, NAMESPACE + objectType + DELIMITER, DELIMITER));
    }

    private void validateCompositeKeySegment(String segment) {
        Matcher matcher = Pattern.compile(INVALID_SEGMENT_PATTERN).matcher(segment);
        if (matcher.find()) {
            throw CompositeKeyFormatException.forInputString(segment, matcher.group(), matcher.start());
        }
    }
}

