/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.shim.impl;

import com.google.protobuf.ByteString;
import java.time.Instant;
import org.hyperledger.fabric.protos.ledger.queryresult.KeyModification;

public final class KeyModificationImpl
implements org.hyperledger.fabric.shim.ledger.KeyModification {
    private final String txId;
    private final ByteString value;
    private final Instant timestamp;
    private final boolean deleted;

    KeyModificationImpl(KeyModification km) {
        this.txId = km.getTxId();
        this.value = km.getValue();
        this.timestamp = Instant.ofEpochSecond(km.getTimestamp().getSeconds(), km.getTimestamp().getNanos());
        this.deleted = km.getIsDelete();
    }

    @Override
    public String getTxId() {
        return this.txId;
    }

    @Override
    public byte[] getValue() {
        return this.value.toByteArray();
    }

    @Override
    public String getStringValue() {
        return this.value.toStringUtf8();
    }

    @Override
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.deleted ? 1231 : 1237);
        result = 31 * result + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        result = 31 * result + (this.txId == null ? 0 : this.txId.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyModificationImpl other = (KeyModificationImpl)obj;
        if (this.deleted != other.deleted) {
            return false;
        }
        if (!this.timestamp.equals(other.timestamp)) {
            return false;
        }
        if (!this.txId.equals(other.txId)) {
            return false;
        }
        return this.value.equals((Object)other.value);
    }
}

