/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.contract.routing.impl;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.hyperledger.fabric.Logger;
import org.hyperledger.fabric.contract.ContractInterface;
import org.hyperledger.fabric.contract.ContractRuntimeException;
import org.hyperledger.fabric.contract.annotation.Contract;
import org.hyperledger.fabric.contract.annotation.DataType;
import org.hyperledger.fabric.contract.annotation.Transaction;
import org.hyperledger.fabric.contract.execution.InvocationRequest;
import org.hyperledger.fabric.contract.routing.ContractDefinition;
import org.hyperledger.fabric.contract.routing.RoutingRegistry;
import org.hyperledger.fabric.contract.routing.TxFunction;
import org.hyperledger.fabric.contract.routing.TypeRegistry;
import org.hyperledger.fabric.contract.routing.impl.ContractDefinitionImpl;

public final class RoutingRegistryImpl
implements RoutingRegistry {
    private static Logger logger = Logger.getLogger(RoutingRegistryImpl.class);
    private final Map<String, ContractDefinition> contracts = new HashMap<String, ContractDefinition>();

    @Override
    public ContractDefinition addNewContract(Class<ContractInterface> clz) {
        logger.debug(() -> "Adding new Contract Class " + clz.getCanonicalName());
        ContractDefinitionImpl contract = new ContractDefinitionImpl(clz);
        this.contracts.put(contract.getName(), contract);
        if (contract.isDefault()) {
            this.contracts.put("default", contract);
        }
        logger.debug(() -> "Put new contract in under name " + contract.getName());
        return contract;
    }

    @Override
    public boolean containsRoute(InvocationRequest request) {
        ContractDefinition cd;
        return this.contracts.containsKey(request.getNamespace()) && (cd = this.contracts.get(request.getNamespace())).hasTxFunction(request.getMethod());
    }

    @Override
    public TxFunction.Routing getRoute(InvocationRequest request) {
        TxFunction txFunction = this.contracts.get(request.getNamespace()).getTxFunction(request.getMethod());
        return txFunction.getRouting();
    }

    @Override
    public TxFunction getTxFn(InvocationRequest request) {
        TxFunction txFunction = this.contracts.get(request.getNamespace()).getTxFunction(request.getMethod());
        return txFunction;
    }

    @Override
    public ContractDefinition getContract(String namespace) {
        ContractDefinition contract = this.contracts.get(namespace);
        if (contract == null) {
            throw new ContractRuntimeException("Undefined contract called");
        }
        return contract;
    }

    @Override
    public Collection<ContractDefinition> getAllDefinitions() {
        return this.contracts.values();
    }

    @Override
    public void findAndSetContracts(TypeRegistry typeRegistry) {
        ClassGraph classGraph = new ClassGraph().enableClassInfo().enableAnnotationInfo();
        ArrayList<Class<ContractInterface>> contractClasses = new ArrayList<Class<ContractInterface>>();
        ArrayList<Class> dataTypeClasses = new ArrayList<Class>();
        try (ScanResult scanResult = classGraph.scan();){
            Annotation annotation;
            for (ClassInfo classInfo : scanResult.getClassesWithAnnotation(Contract.class.getCanonicalName())) {
                logger.debug("Found class with contract annotation: " + classInfo.getName());
                try {
                    Class contractClass = classInfo.loadClass();
                    logger.debug("Loaded class");
                    annotation = contractClass.getAnnotation(Contract.class);
                    if (annotation == null) {
                        logger.debug("Class does not have compatible contract annotation");
                        continue;
                    }
                    if (!ContractInterface.class.isAssignableFrom(contractClass)) {
                        logger.debug("Class is not assignable from ContractInterface");
                        continue;
                    }
                    logger.debug("Class is assignable from ContractInterface");
                    contractClasses.add(contractClass);
                }
                catch (IllegalArgumentException e) {
                    logger.debug("Failed to load class: " + e);
                }
            }
            for (ClassInfo classInfo : scanResult.getClassesWithAnnotation(DataType.class.getCanonicalName())) {
                logger.debug("Found class with data type annotation: " + classInfo.getName());
                try {
                    Class dataTypeClass = classInfo.loadClass();
                    logger.debug("Loaded class");
                    annotation = dataTypeClass.getAnnotation(DataType.class);
                    if (annotation == null) {
                        logger.debug("Class does not have compatible data type annotation");
                        continue;
                    }
                    logger.debug("Class has compatible data type annotation");
                    dataTypeClasses.add(dataTypeClass);
                }
                catch (IllegalArgumentException e) {
                    logger.debug("Failed to load class: " + e);
                }
            }
        }
        this.addContracts(contractClasses);
        dataTypeClasses.forEach(typeRegistry::addDataType);
    }

    private void addContracts(List<Class<ContractInterface>> contractClasses) {
        HashSet<String> seenClass = new HashSet<String>();
        for (Class<ContractInterface> contractClass : contractClasses) {
            String className = contractClass.getCanonicalName();
            if (seenClass.contains(className)) continue;
            ContractDefinition contract = this.addNewContract(contractClass);
            logger.debug("Searching annotated methods");
            for (Method m : contractClass.getMethods()) {
                if (m.getAnnotation(Transaction.class) == null) continue;
                logger.debug("Found annotated method " + m.getName());
                contract.addTxFunction(m);
            }
            seenClass.add(className);
        }
    }
}

