/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.contract.routing.impl;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.hyperledger.fabric.contract.annotation.Property;
import org.hyperledger.fabric.contract.metadata.TypeSchema;
import org.hyperledger.fabric.contract.routing.DataTypeDefinition;
import org.hyperledger.fabric.contract.routing.PropertyDefinition;
import org.hyperledger.fabric.contract.routing.impl.PropertyDefinitionImpl;

public final class DataTypeDefinitionImpl
implements DataTypeDefinition {
    private final Map<String, PropertyDefinition> properties = new HashMap<String, PropertyDefinition>();
    private final String name;
    private final String simpleName;
    private final Class<?> clazz;

    public DataTypeDefinitionImpl(Class<?> componentClass) {
        Field[] fields;
        this.clazz = componentClass;
        this.name = componentClass.getName();
        this.simpleName = componentClass.getSimpleName();
        for (Field f : fields = componentClass.getDeclaredFields()) {
            Property propAnnotation = f.getAnnotation(Property.class);
            if (propAnnotation == null) continue;
            TypeSchema ts = TypeSchema.typeConvert(f.getType());
            String[] userSupplied = propAnnotation.schema();
            for (int i = 0; i < userSupplied.length; i += 2) {
                A[] userValue;
                String userKey = userSupplied[i];
                switch (userKey.toLowerCase()) {
                    case "title": 
                    case "pattern": {
                        userValue = userSupplied[i + 1];
                        break;
                    }
                    case "uniqueitems": {
                        userValue = Boolean.parseBoolean(userSupplied[i + 1]);
                        break;
                    }
                    case "required": 
                    case "enum": {
                        userValue = Stream.of(userSupplied[i + 1].split(",")).map(String::trim).toArray(String[]::new);
                        break;
                    }
                    default: {
                        userValue = Integer.parseInt(userSupplied[i + 1]);
                    }
                }
                ts.put(userKey, userValue);
            }
            PropertyDefinitionImpl propDef = new PropertyDefinitionImpl(f.getName(), f.getClass(), ts, f);
            this.properties.put(f.getName(), propDef);
        }
    }

    @Override
    public Class<?> getTypeClass() {
        return this.clazz;
    }

    @Override
    public TypeSchema getSchema() {
        return TypeSchema.typeConvert(this.clazz);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, PropertyDefinition> getProperties() {
        return this.properties;
    }

    @Override
    public String getSimpleName() {
        return this.simpleName;
    }

    public String toString() {
        return this.simpleName + " " + this.properties;
    }
}

