/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeChangeNotificationFilter;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeOperationsException;
import javax.management.ServiceNotFoundException;
import javax.management.loading.ClassLoaderRepository;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import mx4j.ImplementationException;
import mx4j.log.FileLogger;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.log.MBeanLogger;
import mx4j.persist.FilePersister;
import mx4j.persist.MBeanPersister;
import mx4j.persist.PersisterMBean;
import mx4j.util.Utils;

public class RequiredModelMBean
implements ModelMBean,
MBeanRegistration,
NotificationEmitter {
    private static final String OBJECT_RESOURCE_TYPE = "ObjectReference";
    private static final ModelMBeanInfoSupport DEFAULT_INFO;
    private static final ModelMBeanNotificationInfo GENERIC_INFO;
    private static final ModelMBeanNotificationInfo ATTR_CHANGE_INFO;
    private static final int ALWAYS_STALE = 1;
    private static final int NEVER_STALE = 2;
    private static final int STALE = 3;
    private static final int NOT_STALE = 4;
    private static final int PERSIST_NEVER = -1;
    private static final int PERSIST_ON_TIMER = -2;
    private static final int PERSIST_ON_UPDATE = -3;
    private static final int PERSIST_NO_MORE_OFTEN_THAN = -4;
    private MBeanServer m_mbeanServer;
    private Object m_managedResource;
    private ModelMBeanInfo m_modelMBeanInfo;
    private NotificationBroadcasterSupport m_generalBroadcaster = new NotificationBroadcasterSupport();
    static /* synthetic */ Class class$javax$management$modelmbean$RequiredModelMBean;
    static /* synthetic */ Class class$mx4j$persist$PersisterMBean;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public RequiredModelMBean() throws MBeanException, RuntimeOperationsException {
        this.m_modelMBeanInfo = DEFAULT_INFO;
    }

    public RequiredModelMBean(ModelMBeanInfo info) throws MBeanException, RuntimeOperationsException {
        if (info == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ModelMBeanInfo parameter can't be null"));
        }
        this.setModelMBeanInfo(info);
    }

    private Logger getLogger() {
        return Log.getLogger((String)this.getClass().getName());
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (name == null) {
            throw new IllegalArgumentException("ObjectName is null");
        }
        this.m_mbeanServer = server;
        return name;
    }

    public void postRegister(Boolean registrationDone) {
        if (!registrationDone.booleanValue()) {
            this.clear();
        }
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
        this.clear();
    }

    private void clear() {
        this.m_mbeanServer = null;
    }

    public void setModelMBeanInfo(ModelMBeanInfo modelMBeanInfo) throws MBeanException, RuntimeOperationsException {
        if (this.m_mbeanServer != null) {
            throw new RuntimeOperationsException(new IllegalStateException("setModelMBeanInfo cannot be called when ModelMBean is registered"));
        }
        if (modelMBeanInfo == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ModelMBeanInfo cannot be null"));
        }
        if (!this.isModelMBeanInfoValid(modelMBeanInfo)) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ModelMBeanInfo is invalid"));
        }
        this.m_modelMBeanInfo = new ModelMBeanInfoSupport(modelMBeanInfo);
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(10)) {
            logger.debug((Object)("ModelMBeanInfo successfully set to: " + this.m_modelMBeanInfo));
        }
    }

    private boolean isModelMBeanInfoValid(ModelMBeanInfo info) {
        return info != null && info.getClassName() != null;
    }

    public void setManagedResource(Object resource, String resourceType) throws MBeanException, RuntimeOperationsException, InstanceNotFoundException, InvalidTargetObjectTypeException {
        if (!this.isResourceTypeSupported(resourceType)) {
            throw new InvalidTargetObjectTypeException(resourceType);
        }
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(10)) {
            logger.debug((Object)("Setting managed resource to be: " + resource));
        }
        this.m_managedResource = resource;
    }

    private boolean isResourceTypeSupported(String resourceType) {
        return OBJECT_RESOURCE_TYPE.equalsIgnoreCase(resourceType);
    }

    private Object getManagedResource() {
        return this.m_managedResource;
    }

    public MBeanInfo getMBeanInfo() {
        return this.m_modelMBeanInfo == null ? null : (MBeanInfo)this.m_modelMBeanInfo.clone();
    }

    public void addAttributeChangeNotificationListener(NotificationListener listener, String attributeName, Object handback) throws MBeanException, RuntimeOperationsException, IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        AttributeChangeNotificationFilter filter = new AttributeChangeNotificationFilter();
        if (attributeName != null) {
            if (this.m_modelMBeanInfo.getAttribute(attributeName) == null) {
                throw new RuntimeOperationsException(new IllegalArgumentException("No attribute named " + attributeName));
            }
            filter.enableAttribute(attributeName);
        } else {
            MBeanAttributeInfo[] ai = this.m_modelMBeanInfo.getAttributes();
            for (int i = 0; i < ai.length; ++i) {
                Descriptor d = ((ModelMBeanAttributeInfo)ai[i]).getDescriptor();
                filter.enableAttribute((String)d.getFieldValue("name"));
            }
        }
        this.getAttributeChangeBroadcaster().addNotificationListener(listener, filter, handback);
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(10)) {
            logger.debug((Object)("Listener " + listener + " for attribute " + attributeName + " added successfully, handback is " + handback));
        }
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        this.m_generalBroadcaster.addNotificationListener(listener, filter, handback);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] notifications = this.m_modelMBeanInfo.getNotifications();
        boolean hasGeneric = false;
        boolean hasAttribute = false;
        int toAdd = 2;
        for (int i = 0; i < notifications.length; ++i) {
            String name = notifications[i].getName();
            if ("GENERIC".equals(name)) {
                hasGeneric = true;
                --toAdd;
                if (!hasAttribute) continue;
                break;
            }
            if (!"ATTRIBUTE_CHANGE".equals(name)) continue;
            hasAttribute = true;
            --toAdd;
            if (hasGeneric) break;
        }
        MBeanNotificationInfo[] newNotifications = new MBeanNotificationInfo[notifications.length + toAdd];
        System.arraycopy(notifications, 0, newNotifications, toAdd, notifications.length);
        if (!hasAttribute) {
            newNotifications[--toAdd] = ATTR_CHANGE_INFO;
        }
        if (!hasGeneric) {
            newNotifications[--toAdd] = GENERIC_INFO;
        }
        return newNotifications;
    }

    public void removeAttributeChangeNotificationListener(NotificationListener listener, String attributeName) throws MBeanException, RuntimeOperationsException, ListenerNotFoundException {
        this.removeAttributeChangeNotificationListener(listener, attributeName, null);
    }

    private void removeAttributeChangeNotificationListener(NotificationListener listener, String attributeName, Object handback) throws MBeanException, RuntimeOperationsException, ListenerNotFoundException {
        if (listener == null) {
            throw new ListenerNotFoundException("listener is null");
        }
        AttributeChangeNotificationFilter filter = new AttributeChangeNotificationFilter();
        if (attributeName != null) {
            if (this.m_modelMBeanInfo.getAttribute(attributeName) == null) {
                throw new RuntimeOperationsException(new IllegalArgumentException("No attribute named " + attributeName));
            }
            filter.enableAttribute(attributeName);
        } else {
            MBeanAttributeInfo[] ai = this.m_modelMBeanInfo.getAttributes();
            for (int i = 0; i < ai.length; ++i) {
                Descriptor d = ((ModelMBeanAttributeInfo)ai[i]).getDescriptor();
                filter.enableAttribute((String)d.getFieldValue("name"));
            }
        }
        this.getAttributeChangeBroadcaster().removeNotificationListener(listener, filter, handback);
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(10)) {
            logger.debug((Object)("Listener " + listener + " for attribute " + attributeName + " removed successfully, handback is " + handback));
        }
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.m_generalBroadcaster.removeNotificationListener(listener);
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.m_generalBroadcaster.removeNotificationListener(listener, filter, handback);
    }

    public void sendAttributeChangeNotification(Attribute oldAttribute, Attribute newAttribute) throws MBeanException, RuntimeOperationsException {
        if (oldAttribute == null || newAttribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"));
        }
        if (!oldAttribute.getName().equals(newAttribute.getName())) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute names cannot be different"));
        }
        Object oldValue = oldAttribute.getValue();
        AttributeChangeNotification n = new AttributeChangeNotification(this, 1L, System.currentTimeMillis(), "Attribute value changed", oldAttribute.getName(), oldValue == null ? null : oldValue.getClass().getName(), oldValue, newAttribute.getValue());
        this.sendAttributeChangeNotification(n);
    }

    public void sendAttributeChangeNotification(AttributeChangeNotification notification) throws MBeanException, RuntimeOperationsException {
        Logger logger;
        if (notification == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Notification cannot be null"));
        }
        this.getAttributeChangeBroadcaster().sendNotification(notification);
        Logger modelMBeanLogger = this.getModelMBeanLogger(notification.getType());
        if (modelMBeanLogger != null && modelMBeanLogger.isEnabledFor(10)) {
            modelMBeanLogger.debug((Object)("ModelMBean log: " + new Date() + " - " + notification));
        }
        if ((logger = this.getLogger()).isEnabledFor(10)) {
            logger.debug((Object)("Attribute change notification " + notification + " sent"));
        }
    }

    public void sendNotification(String message) throws MBeanException, RuntimeOperationsException {
        if (message == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("message is null"));
        }
        Notification notification = new Notification("jmx.modelmbean.generic", (Object)this, 1L, message);
        this.sendNotification(notification);
    }

    public void sendNotification(Notification notification) throws MBeanException, RuntimeOperationsException {
        if (notification == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("notification is null"));
        }
        this.m_generalBroadcaster.sendNotification(notification);
    }

    public AttributeList getAttributes(String[] attributes) {
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute names cannot be null"));
        }
        Logger logger = this.getLogger();
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributes.length; ++i) {
            String attrName = attributes[i];
            Attribute attribute = null;
            try {
                Object value = this.getAttribute(attrName);
                attribute = new Attribute(attrName, value);
                list.add(attribute);
                continue;
            }
            catch (Exception x) {
                if (!logger.isEnabledFor(0)) continue;
                logger.trace((Object)("getAttribute for attribute " + attrName + " failed"), (Throwable)x);
            }
        }
        return list;
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Descriptor attributeDescriptor;
        ModelMBeanAttributeInfo attrInfo;
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"));
        }
        Logger logger = this.getLogger();
        ModelMBeanInfo info = this.getModelMBeanInfo();
        if (info == null) {
            throw new AttributeNotFoundException("ModelMBeanInfo is null");
        }
        if (logger.isEnabledFor(10)) {
            logger.debug((Object)("ModelMBeanInfo is: " + info));
        }
        if ((attrInfo = info.getAttribute(attribute)) == null) {
            throw new AttributeNotFoundException("Cannot find ModelMBeanAttributeInfo for attribute " + attribute);
        }
        if (logger.isEnabledFor(10)) {
            logger.debug((Object)("Attribute info is: " + attrInfo));
        }
        if (!attrInfo.isReadable()) {
            throw new AttributeNotFoundException("Attribute " + attribute + " is not readable");
        }
        Descriptor mbeanDescriptor = info.getMBeanDescriptor();
        if (mbeanDescriptor == null) {
            throw new AttributeNotFoundException("MBean descriptor cannot be null");
        }
        if (logger.isEnabledFor(10)) {
            logger.debug((Object)("MBean descriptor is: " + mbeanDescriptor));
        }
        if ((attributeDescriptor = attrInfo.getDescriptor()) == null) {
            throw new AttributeNotFoundException("Attribute descriptor for attribute " + attribute + " cannot be null");
        }
        if (logger.isEnabledFor(10)) {
            logger.debug((Object)("Attribute descriptor is: " + attributeDescriptor));
        }
        Object returnValue = null;
        String lastUpdateField = "lastUpdatedTimeStamp";
        int staleness = this.getStaleness(attributeDescriptor, mbeanDescriptor, lastUpdateField);
        if (staleness == 1 || staleness == 3) {
            if (logger.isEnabledFor(0)) {
                logger.trace((Object)"Value is stale");
            }
            String getter = (String)attributeDescriptor.getFieldValue("getMethod");
            if (logger.isEnabledFor(10)) {
                logger.debug((Object)("getMethod field is: " + getter));
            }
            if (getter == null) {
                returnValue = attributeDescriptor.getFieldValue("default");
                if (returnValue != null) {
                    Class<?> returned = returnValue.getClass();
                    Class declared = this.loadClassWithContextClassLoader(attrInfo.getType());
                    this.checkAssignability(returned, declared);
                }
                if (logger.isEnabledFor(10)) {
                    logger.debug((Object)("getAttribute for attribute " + attribute + " returns default value: " + returnValue));
                }
            } else {
                if (logger.isEnabledFor(0)) {
                    logger.trace((Object)"Invoking attribute getter...");
                }
                Object target = this.resolveTargetObject(attributeDescriptor);
                returnValue = this.invokeMethod(target, getter, new Class[0], new Object[0]);
                if (logger.isEnabledFor(10)) {
                    logger.debug((Object)("Returned value is: " + returnValue));
                }
                if (returnValue != null) {
                    Class<?> returned = returnValue.getClass();
                    Class declared = this.loadClassWithContextClassLoader(attrInfo.getType());
                    this.checkAssignability(returned, declared);
                }
                if (staleness != 1) {
                    attributeDescriptor.setField("value", returnValue);
                    attributeDescriptor.setField(lastUpdateField, new Long(System.currentTimeMillis()));
                    if (logger.isEnabledFor(0)) {
                        logger.trace((Object)"Returned value has been cached");
                    }
                    info.setDescriptor(attributeDescriptor, "attribute");
                }
                if (logger.isEnabledFor(10)) {
                    logger.debug((Object)("getAttribute for attribute " + attribute + " returns invoked value: " + returnValue));
                }
            }
        } else {
            returnValue = attributeDescriptor.getFieldValue("value");
            if (returnValue != null) {
                Class<?> returned = returnValue.getClass();
                Class declared = this.loadClassWithContextClassLoader(attrInfo.getType());
                this.checkAssignability(returned, declared);
            }
            if (logger.isEnabledFor(10)) {
                logger.debug((Object)("getAttribute for attribute " + attribute + " returns cached value: " + returnValue));
            }
        }
        return returnValue;
    }

    public AttributeList setAttributes(AttributeList attributes) {
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute list cannot be null"));
        }
        Logger logger = this.getLogger();
        AttributeList list = new AttributeList();
        Iterator i = attributes.iterator();
        while (i.hasNext()) {
            Attribute attribute = (Attribute)i.next();
            String name = attribute.getName();
            try {
                this.setAttribute(attribute);
                list.add(attribute);
            }
            catch (Exception x) {
                if (!logger.isEnabledFor(0)) continue;
                logger.trace((Object)("setAttribute for attribute " + name + " failed"), (Throwable)x);
            }
        }
        return list;
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Object oldValue;
        String lastUpdateField;
        Descriptor attributeDescriptor;
        Descriptor mbeanDescriptor;
        ModelMBeanAttributeInfo attrInfo;
        Object attrValue;
        String attrName;
        ModelMBeanInfo info;
        Logger logger;
        block29: {
            if (attribute == null) {
                throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"));
            }
            logger = this.getLogger();
            info = this.getModelMBeanInfo();
            if (info == null) {
                throw new AttributeNotFoundException("ModelMBeanInfo is null");
            }
            if (logger.isEnabledFor(10)) {
                logger.debug((Object)("ModelMBeanInfo is: " + info));
            }
            attrName = attribute.getName();
            attrValue = attribute.getValue();
            attrInfo = info.getAttribute(attrName);
            if (attrInfo == null) {
                throw new AttributeNotFoundException("Cannot find ModelMBeanAttributeInfo for attribute " + attrName);
            }
            if (logger.isEnabledFor(10)) {
                logger.debug((Object)("Attribute info is: " + attrInfo));
            }
            if (!attrInfo.isWritable()) {
                throw new AttributeNotFoundException("Attribute " + attrName + " is not writable");
            }
            mbeanDescriptor = info.getMBeanDescriptor();
            if (mbeanDescriptor == null) {
                throw new AttributeNotFoundException("MBean descriptor cannot be null");
            }
            if (logger.isEnabledFor(10)) {
                logger.debug((Object)("MBean descriptor is: " + mbeanDescriptor));
            }
            if ((attributeDescriptor = attrInfo.getDescriptor()) == null) {
                throw new AttributeNotFoundException("Attribute descriptor for attribute " + attrName + " cannot be null");
            }
            if (logger.isEnabledFor(10)) {
                logger.debug((Object)("Attribute descriptor is: " + attributeDescriptor));
            }
            lastUpdateField = "lastUpdatedTimeStamp";
            oldValue = null;
            try {
                oldValue = this.getAttribute(attrName);
                if (logger.isEnabledFor(10)) {
                    logger.debug((Object)("Previous value of attribute " + attrName + ": " + oldValue));
                }
            }
            catch (Exception x) {
                if (!logger.isEnabledFor(10)) break block29;
                logger.debug((Object)("Cannot get previous value of attribute " + attrName), (Throwable)x);
            }
        }
        String method = (String)attributeDescriptor.getFieldValue("setMethod");
        if (logger.isEnabledFor(10)) {
            logger.debug((Object)("setMethod field is: " + method));
        }
        if (method != null) {
            Class declared = this.loadClassWithContextClassLoader(attrInfo.getType());
            if (attrValue != null) {
                Class<?> parameter = attrValue.getClass();
                this.checkAssignability(parameter, declared);
            }
            Object target = this.resolveTargetObject(attributeDescriptor);
            this.invokeMethod(target, method, new Class[]{declared}, new Object[]{attrValue});
            int staleness = this.getStaleness(attributeDescriptor, mbeanDescriptor, lastUpdateField);
            if (staleness != 1) {
                attributeDescriptor.setField("value", attrValue);
                attributeDescriptor.setField(lastUpdateField, new Long(System.currentTimeMillis()));
                if (logger.isEnabledFor(0)) {
                    logger.trace((Object)"Attribute's value has been cached");
                }
            } else if (logger.isEnabledFor(0)) {
                logger.trace((Object)"Always stale, avoiding to cache attribute's value");
            }
        } else {
            if (attrValue != null) {
                Class<?> parameter = attrValue.getClass();
                Class declared = this.loadClassWithContextClassLoader(attrInfo.getType());
                this.checkAssignability(parameter, declared);
            }
            attributeDescriptor.setField("value", attrValue);
        }
        info.setDescriptor(attributeDescriptor, "attribute");
        if (logger.isEnabledFor(0)) {
            logger.trace((Object)"Sending attribute change notifications");
        }
        this.sendAttributeChangeNotification(new Attribute(attrName, oldValue), attribute);
        boolean persistNow = this.shouldPersistNow(attributeDescriptor, mbeanDescriptor, lastUpdateField);
        if (persistNow) {
            if (logger.isEnabledFor(0)) {
                logger.trace((Object)"Persisting this ModelMBean...");
            }
            try {
                this.store();
                if (logger.isEnabledFor(0)) {
                    logger.trace((Object)"ModelMBean persisted successfully");
                }
            }
            catch (Exception x) {
                logger.error((Object)"Cannot store ModelMBean after setAttribute", (Throwable)x);
                if (x instanceof MBeanException) {
                    throw (MBeanException)x;
                }
                throw new MBeanException(x);
            }
        }
    }

    public Object invoke(String method, Object[] arguments, String[] params) throws MBeanException, ReflectionException {
        Descriptor mbeanDescriptor;
        Descriptor operationDescriptor;
        ModelMBeanOperationInfo operInfo;
        if (method == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Method name cannot be null"));
        }
        if (arguments == null) {
            arguments = new Object[]{};
        }
        if (params == null) {
            params = new String[]{};
        }
        Logger logger = this.getLogger();
        ModelMBeanInfo info = this.getModelMBeanInfo();
        if (info == null) {
            throw new MBeanException(new ServiceNotFoundException("ModelMBeanInfo is null"));
        }
        if (logger.isEnabledFor(10)) {
            logger.debug((Object)("ModelMBeanInfo is: " + info));
        }
        if ((operInfo = info.getOperation(method)) == null) {
            try {
                Class[] clzArgs = new Class[params.length];
                for (int i = 0; i < clzArgs.length; ++i) {
                    ClassLoader loader = this.getClass().getClassLoader();
                    if (loader == null) {
                        loader = Thread.currentThread().getContextClassLoader();
                    }
                    clzArgs[i] = loader.loadClass(params[i]);
                }
                Method invocationMethod = this.getClass().getMethod(method, clzArgs);
                operInfo = new ModelMBeanOperationInfo("", invocationMethod);
            }
            catch (Exception e) {
                throw new MBeanException(new ServiceNotFoundException("Cannot find ModelMBeanOperationInfo for operation " + method));
            }
        }
        if (logger.isEnabledFor(10)) {
            logger.debug((Object)("Operation info is: " + operInfo));
        }
        if ((operationDescriptor = operInfo.getDescriptor()) == null) {
            throw new MBeanException(new ServiceNotFoundException("Operation descriptor for operation " + method + " cannot be null"));
        }
        String role = (String)operationDescriptor.getFieldValue("role");
        if (role == null || !role.equals("operation")) {
            throw new MBeanException(new ServiceNotFoundException("Operation descriptor field 'role' must be 'operation', not " + role));
        }
        if (logger.isEnabledFor(10)) {
            logger.debug((Object)("Operation descriptor is: " + operationDescriptor));
        }
        if ((mbeanDescriptor = info.getMBeanDescriptor()) == null) {
            throw new MBeanException(new ServiceNotFoundException("MBean descriptor cannot be null"));
        }
        if (logger.isEnabledFor(10)) {
            logger.debug((Object)("MBean descriptor is: " + mbeanDescriptor));
        }
        Object returnValue = null;
        String lastUpdateField = "lastReturnedTimeStamp";
        int staleness = this.getStaleness(operationDescriptor, mbeanDescriptor, lastUpdateField);
        if (staleness == 1 || staleness == 3) {
            if (logger.isEnabledFor(0)) {
                logger.trace((Object)"Value is stale");
            }
            Class[] parameters = null;
            try {
                parameters = Utils.loadClasses((ClassLoader)Thread.currentThread().getContextClassLoader(), (String[])params);
            }
            catch (ClassNotFoundException x) {
                logger.error((Object)"Cannot find operation's parameter classes", (Throwable)x);
                throw new ReflectionException(x);
            }
            if (logger.isEnabledFor(0)) {
                logger.trace((Object)"Invoking operation...");
            }
            Object target = this.resolveTargetObject(operationDescriptor);
            returnValue = this.invokeMethod(target, method, parameters, arguments);
            if (logger.isEnabledFor(10)) {
                logger.debug((Object)("Returned value is: " + returnValue));
            }
            if (returnValue != null) {
                Class<?> parameter = returnValue.getClass();
                Class declared = this.loadClassWithContextClassLoader(operInfo.getReturnType());
                this.checkAssignability(parameter, declared);
            }
            if (staleness != 1) {
                operationDescriptor.setField("lastReturnedValue", returnValue);
                operationDescriptor.setField(lastUpdateField, new Long(System.currentTimeMillis()));
                if (logger.isEnabledFor(0)) {
                    logger.trace((Object)"Returned value has been cached");
                }
                info.setDescriptor(operationDescriptor, "operation");
            }
            if (logger.isEnabledFor(10)) {
                logger.debug((Object)("invoke for operation " + method + " returns invoked value: " + returnValue));
            }
        } else {
            returnValue = operationDescriptor.getFieldValue("lastReturnedValue");
            if (returnValue != null) {
                Class<?> parameter = returnValue.getClass();
                Class declared = this.loadClassWithContextClassLoader(operInfo.getReturnType());
                this.checkAssignability(parameter, declared);
            }
            if (logger.isEnabledFor(10)) {
                logger.debug((Object)("invoke for operation " + method + " returns cached value: " + returnValue));
            }
        }
        boolean persistNow = this.shouldPersistNow(operationDescriptor, null, lastUpdateField);
        int impact = operInfo.getImpact();
        if (persistNow && impact != 0) {
            if (logger.isEnabledFor(0)) {
                logger.trace((Object)"Persisting this ModelMBean...");
            }
            try {
                this.store();
                if (logger.isEnabledFor(0)) {
                    logger.trace((Object)"ModelMBean persisted successfully");
                }
            }
            catch (Exception x) {
                logger.error((Object)"Cannot store ModelMBean after operation invocation", (Throwable)x);
                if (x instanceof MBeanException) {
                    throw (MBeanException)x;
                }
                throw new MBeanException(x);
            }
        }
        return returnValue;
    }

    private Object resolveTargetObject(Descriptor descriptor) throws MBeanException {
        Logger logger = this.getLogger();
        Object target = descriptor.getFieldValue("targetObject");
        if (logger.isEnabledFor(0)) {
            logger.trace((Object)("targetObject is: " + target));
        }
        if (target == null) {
            target = this.getManagedResource();
        } else {
            String targetObjectType = (String)descriptor.getFieldValue("targetObjectType");
            if (logger.isEnabledFor(0)) {
                logger.trace((Object)("targetObjectType is: " + targetObjectType));
            }
            if (targetObjectType == null) {
                targetObjectType = OBJECT_RESOURCE_TYPE;
            }
            if (!this.isResourceTypeSupported(targetObjectType)) {
                throw new MBeanException(new InvalidTargetObjectTypeException(targetObjectType));
            }
        }
        return target;
    }

    public void load() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
        PersisterMBean persister = this.findPersister();
        if (persister != null) {
            ModelMBeanInfo info = (ModelMBeanInfo)persister.load();
            this.setModelMBeanInfo(info);
        }
    }

    public void store() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
        PersisterMBean persister = this.findPersister();
        if (persister != null) {
            ModelMBeanInfo info = (ModelMBeanInfo)((Object)this.getMBeanInfo());
            persister.store((Object)info);
        }
    }

    protected ClassLoaderRepository getClassLoaderRepository() {
        if (this.m_mbeanServer != null) {
            return this.m_mbeanServer.getClassLoaderRepository();
        }
        return null;
    }

    private boolean shouldPersistNow(Descriptor attribute, Descriptor mbean, String lastUpdateField) {
        int persist = this.getPersistPolicy(attribute, mbean);
        if (persist == -4) {
            Long lastUpdate;
            Long period = this.getFieldTimeValue(attribute, mbean, "persistPeriod");
            long now = System.currentTimeMillis();
            return now - (lastUpdate = (Long)attribute.getFieldValue(lastUpdateField)) >= period;
        }
        if (persist == -1) {
            return false;
        }
        if (persist == -2) {
            return false;
        }
        if (persist == -3) {
            return true;
        }
        throw new ImplementationException("Invalid persist value");
    }

    private int getPersistPolicy(Descriptor descriptor, Descriptor mbean) {
        Logger logger = this.getLogger();
        String persist = (String)descriptor.getFieldValue("persistPolicy");
        if (persist == null && mbean != null) {
            persist = (String)mbean.getFieldValue("persistPolicy");
        }
        if (persist == null) {
            if (logger.isEnabledFor(0)) {
                logger.trace((Object)"No persist policy defined, assuming Never");
            }
            return -1;
        }
        if (persist.equals("Never")) {
            if (logger.isEnabledFor(0)) {
                logger.trace((Object)"Persist never");
            }
            return -1;
        }
        if (persist.equals("OnUpdate")) {
            if (logger.isEnabledFor(0)) {
                logger.trace((Object)"Persist on update");
            }
            return -3;
        }
        if (persist.equals("OnTimer")) {
            if (logger.isEnabledFor(0)) {
                logger.trace((Object)"Persist on update");
            }
            return -2;
        }
        if (persist.equals("NoMoreOftenThan")) {
            if (logger.isEnabledFor(0)) {
                Long period = this.getFieldTimeValue(descriptor, mbean, "persistPeriod");
                logger.trace((Object)("Persist no more often than " + period));
            }
            return -4;
        }
        if (logger.isEnabledFor(0)) {
            logger.trace((Object)"Invalid persist policy, assuming persist never");
        }
        return -1;
    }

    private int getStaleness(Descriptor attribute, Descriptor mbean, String lastUpdateField) {
        long now;
        Logger logger = this.getLogger();
        Long currencyTimeLimit = this.getFieldTimeValue(attribute, mbean, "currencyTimeLimit");
        if (currencyTimeLimit == null) {
            if (logger.isEnabledFor(0)) {
                logger.trace((Object)"No currencyTimeLimit defined, assuming always stale");
            }
            return 1;
        }
        long ctl = currencyTimeLimit * 1000L;
        if (logger.isEnabledFor(0)) {
            logger.trace((Object)("currencyTimeLimit is (ms): " + ctl));
        }
        if (ctl == 0L) {
            if (logger.isEnabledFor(0)) {
                logger.trace((Object)"Never stale");
            }
            return 2;
        }
        if (ctl < 0L) {
            if (logger.isEnabledFor(0)) {
                logger.trace((Object)"Always stale");
            }
            return 1;
        }
        Long timestamp = (Long)attribute.getFieldValue(lastUpdateField);
        long luts = 0L;
        if (timestamp != null) {
            luts = timestamp;
        }
        if (logger.isEnabledFor(10)) {
            logger.debug((Object)(lastUpdateField + " is: " + luts));
        }
        if ((now = System.currentTimeMillis()) < luts + ctl) {
            if (timestamp == null) {
                if (logger.isEnabledFor(0)) {
                    logger.trace((Object)"Stale since was never set");
                }
                return 3;
            }
            if (logger.isEnabledFor(0)) {
                logger.trace((Object)"Not stale");
            }
            return 4;
        }
        if (logger.isEnabledFor(0)) {
            logger.trace((Object)"Stale");
        }
        return 3;
    }

    private Long getFieldTimeValue(Descriptor descriptor, Descriptor mbean, String field) {
        Logger logger = this.getLogger();
        Object value = descriptor.getFieldValue(field);
        if (logger.isEnabledFor(10)) {
            logger.debug((Object)("Descriptor's " + field + " field: " + value));
        }
        if (value == null && mbean != null) {
            value = mbean.getFieldValue(field);
            if (logger.isEnabledFor(10)) {
                logger.debug((Object)("MBean's " + field + " field: " + value));
            }
            if (value == null) {
                return null;
            }
        }
        if (value instanceof Number) {
            return new Long(((Number)value).longValue());
        }
        if (value instanceof String) {
            try {
                long ctl = Long.parseLong((String)value);
                return new Long(ctl);
            }
            catch (NumberFormatException x) {
                return new Long(0L);
            }
        }
        return new Long(0L);
    }

    private Object invokeMethod(Object target, String methodName, Class[] params, Object[] args) throws MBeanException, ReflectionException {
        Object realTarget = null;
        Method method = null;
        try {
            realTarget = this;
            method = realTarget.getClass().getMethod(methodName, params);
        }
        catch (NoSuchMethodException x) {
            realTarget = target;
        }
        if (realTarget == null) {
            throw new MBeanException(new ServiceNotFoundException("Could not find target"));
        }
        if (method == null) {
            try {
                method = realTarget.getClass().getMethod(methodName, params);
            }
            catch (NoSuchMethodException x) {
                throw new ReflectionException(x);
            }
        }
        try {
            Object value = method.invoke(realTarget, args);
            Logger logger = this.getLogger();
            if (logger.isEnabledFor(10)) {
                logger.debug((Object)("Method invocation returned value: " + value));
            }
            return value;
        }
        catch (IllegalAccessException x) {
            throw new ReflectionException(x);
        }
        catch (IllegalArgumentException x) {
            throw new MBeanException(x);
        }
        catch (InvocationTargetException x) {
            Throwable t = x.getTargetException();
            if (t instanceof Error) {
                throw new MBeanException(new RuntimeErrorException((Error)t));
            }
            throw new MBeanException((Exception)t);
        }
    }

    private Logger getModelMBeanLogger(String notificationType) throws MBeanException {
        ModelMBeanInfo info = this.getModelMBeanInfo();
        Descriptor descriptor = null;
        Logger modelMBeanLogger = null;
        if (notificationType != null) {
            descriptor = info.getDescriptor(notificationType, "notification");
            modelMBeanLogger = this.findLogger(descriptor);
        }
        if (modelMBeanLogger == null && (modelMBeanLogger = this.findLogger(descriptor = info.getMBeanDescriptor())) != null) {
            return modelMBeanLogger;
        }
        return null;
    }

    private Logger findLogger(Descriptor descriptor) {
        Logger logger = this.getLogger();
        if (descriptor == null) {
            if (logger.isEnabledFor(0)) {
                logger.trace((Object)"Can't find MBean logger, descriptor is null");
            }
            return null;
        }
        String log = (String)descriptor.getFieldValue("log");
        String location = (String)descriptor.getFieldValue("logFile");
        if (logger.isEnabledFor(10)) {
            logger.debug((Object)("Log fields: log=" + log + ", file=" + location));
        }
        if (log == null || !Boolean.valueOf(log).booleanValue()) {
            if (logger.isEnabledFor(10)) {
                logger.debug((Object)"Logging is not supported by this ModelMBean");
            }
            return null;
        }
        if (location == null) {
            location = (String)descriptor.getFieldValue("logMBean");
            if (logger.isEnabledFor(10)) {
                logger.debug((Object)("Log fields: mbean=" + location));
            }
            if (location == null) {
                if (logger.isEnabledFor(0)) {
                    logger.trace((Object)"Logging is not supported by this ModelMBean");
                }
                return null;
            }
            try {
                ObjectName objectName = new ObjectName(location);
                MBeanServer server = this.getMBeanServer();
                if (server == null) {
                    throw new MBeanException(new IllegalStateException("RequiredModelMBean is not registered"));
                }
                if (server.isRegistered(objectName)) {
                    MBeanLogger l = new MBeanLogger(server, objectName);
                    if (logger.isEnabledFor(10)) {
                        logger.debug((Object)("ModelMBean log supported by delegating to this MBean: " + objectName));
                    }
                    return l;
                }
                return null;
            }
            catch (MalformedObjectNameException x) {
                if (logger.isEnabledFor(10)) {
                    logger.debug((Object)("Specified logMBean field does not contain a valid ObjectName: " + location));
                }
                return null;
            }
            catch (MBeanException x) {
                if (logger.isEnabledFor(10)) {
                    logger.debug((Object)"logMBean field does not specify an MBean that supports logging delegation", (Throwable)x);
                }
                return null;
            }
        }
        if (logger.isEnabledFor(10)) {
            logger.debug((Object)"ModelMBean log supported on file system");
        }
        return new FileLogger(location);
    }

    private NotificationBroadcasterSupport getAttributeChangeBroadcaster() {
        return this.m_generalBroadcaster;
    }

    private MBeanServer getMBeanServer() {
        return this.m_mbeanServer;
    }

    private ModelMBeanInfo getModelMBeanInfo() {
        return this.m_modelMBeanInfo;
    }

    private PersisterMBean findPersister() throws MBeanException, InstanceNotFoundException {
        Logger logger = this.getLogger();
        ModelMBeanInfo info = this.getModelMBeanInfo();
        if (info == null) {
            if (logger.isEnabledFor(0)) {
                logger.trace((Object)"Can't find persister, ModelMBeanInfo is null");
            }
            return null;
        }
        Descriptor mbeanDescriptor = info.getMBeanDescriptor();
        if (mbeanDescriptor == null) {
            if (logger.isEnabledFor(0)) {
                logger.trace((Object)"Can't find persister, MBean descriptor is null");
            }
            return null;
        }
        String location = (String)mbeanDescriptor.getFieldValue("persistLocation");
        String name = (String)mbeanDescriptor.getFieldValue("persistName");
        String mbeanName = (String)mbeanDescriptor.getFieldValue("name");
        if (logger.isEnabledFor(10)) {
            logger.debug((Object)("Persistence fields: location=" + location + ", name=" + name));
        }
        if (mbeanName == null && name == null) {
            if (logger.isEnabledFor(10)) {
                logger.debug((Object)"Persistence is not supported by this ModelMBean");
            }
            return null;
        }
        if (name != null) {
            try {
                ObjectName objectName = new ObjectName(name.trim());
                MBeanServer server = this.getMBeanServer();
                if (server == null) {
                    throw new MBeanException(new IllegalStateException("RequiredModelMBean is not registered"));
                }
                if (server.isRegistered(objectName) && server.isInstanceOf(objectName, (class$mx4j$persist$PersisterMBean == null ? (class$mx4j$persist$PersisterMBean = RequiredModelMBean.class$("mx4j.persist.PersisterMBean")) : class$mx4j$persist$PersisterMBean).getName())) {
                    MBeanPersister persister = new MBeanPersister(server, objectName);
                    if (logger.isEnabledFor(10)) {
                        logger.debug((Object)("Persistence is delegated to this MBean: " + objectName));
                    }
                    return persister;
                }
                throw new InstanceNotFoundException(objectName.toString());
            }
            catch (MalformedObjectNameException ignored) {
                if (logger.isEnabledFor(0)) {
                    logger.trace((Object)"Persistence is not delegated to another MBean");
                }
                FilePersister persister = new FilePersister(location, name);
                if (logger.isEnabledFor(10)) {
                    logger.debug((Object)("Persistence is realized through file system in " + persister.getFileName()));
                }
                return persister;
            }
        }
        FilePersister persister = new FilePersister(location, mbeanName);
        if (logger.isEnabledFor(10)) {
            logger.debug((Object)("Persistence is realized through file system in " + persister.getFileName()));
        }
        return persister;
    }

    private Class loadClassWithContextClassLoader(String name) {
        try {
            return Utils.loadClass((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)name);
        }
        catch (ClassNotFoundException x) {
            Logger logger = this.getLogger();
            if (logger.isEnabledFor(0)) {
                logger.trace((Object)"Cannot find attribute's declared return class", (Throwable)x);
            }
            return null;
        }
    }

    private void checkAssignability(Class parameter, Class declared) throws MBeanException {
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(10)) {
            logger.debug((Object)("The class of the parameter is: " + parameter));
            if (parameter != null) {
                logger.debug((Object)("The classloder of the parameter's class is: " + parameter.getClassLoader()));
            }
            logger.debug((Object)("The class declared as type of the attribute is: " + declared));
            if (declared != null) {
                logger.debug((Object)("The classloader of the declared parameter's class is: " + declared.getClassLoader()));
            }
        }
        boolean assignable = false;
        assignable = declared == null || parameter == null ? false : (declared == Boolean.TYPE && parameter == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = RequiredModelMBean.class$("java.lang.Boolean")) : class$java$lang$Boolean) ? true : (declared == Byte.TYPE && parameter == (class$java$lang$Byte == null ? (class$java$lang$Byte = RequiredModelMBean.class$("java.lang.Byte")) : class$java$lang$Byte) ? true : (declared == Character.TYPE && parameter == (class$java$lang$Character == null ? (class$java$lang$Character = RequiredModelMBean.class$("java.lang.Character")) : class$java$lang$Character) ? true : (declared == Short.TYPE && parameter == (class$java$lang$Short == null ? (class$java$lang$Short = RequiredModelMBean.class$("java.lang.Short")) : class$java$lang$Short) ? true : (declared == Integer.TYPE && parameter == (class$java$lang$Integer == null ? (class$java$lang$Integer = RequiredModelMBean.class$("java.lang.Integer")) : class$java$lang$Integer) ? true : (declared == Long.TYPE && parameter == (class$java$lang$Long == null ? (class$java$lang$Long = RequiredModelMBean.class$("java.lang.Long")) : class$java$lang$Long) ? true : (declared == Float.TYPE && parameter == (class$java$lang$Float == null ? (class$java$lang$Float = RequiredModelMBean.class$("java.lang.Float")) : class$java$lang$Float) ? true : (declared == Double.TYPE && parameter == (class$java$lang$Double == null ? (class$java$lang$Double = RequiredModelMBean.class$("java.lang.Double")) : class$java$lang$Double) ? true : declared.isAssignableFrom(parameter)))))))));
        if (!assignable) {
            if (logger.isEnabledFor(0)) {
                logger.trace((Object)"Parameter value's class and attribute's declared return class are not assignable");
            }
            throw new MBeanException(new InvalidAttributeValueException("Returned type and declared type are not assignable"));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String[] fields = new String[]{"name=GENERIC", "descriptorType=notification", "log=T", "severity=6", "displayName=jmx.modelmbean.generic"};
        GENERIC_INFO = new ModelMBeanNotificationInfo(new String[]{"jmx.modelmbean.generic"}, "GENERIC", "", new DescriptorSupport(fields));
        fields = new String[]{"name=ATTRIBUTE_CHANGE", "descriptorType=notification", "log=T", "severity=6", "displayName=jmx.attribute.change"};
        ATTR_CHANGE_INFO = new ModelMBeanNotificationInfo(new String[]{"jmx.attribute.change"}, "ATTRIBUTE_CHANGE", "", new DescriptorSupport(fields));
        DEFAULT_INFO = new ModelMBeanInfoSupport((class$javax$management$modelmbean$RequiredModelMBean == null ? (class$javax$management$modelmbean$RequiredModelMBean = RequiredModelMBean.class$("javax.management.modelmbean.RequiredModelMBean")) : class$javax$management$modelmbean$RequiredModelMBean).getName(), null, null, null, null, null);
    }
}

