/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.utils;

import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.api.directions.v5.models.RouteOptions;
import java.util.MissingFormatArgumentException;

public final class ValidationUtils {
    private ValidationUtils() {
    }

    public static void validDirectionsRoute(DirectionsRoute directionsRoute, boolean defaultMilestonesEnabled) {
        if (defaultMilestonesEnabled) {
            RouteOptions routeOptions = directionsRoute.routeOptions();
            ValidationUtils.checkNullRouteOptions(routeOptions);
            ValidationUtils.checkInvalidVoiceInstructions(routeOptions);
            ValidationUtils.checkInvalidBannerInstructions(routeOptions);
        }
    }

    private static void checkNullRouteOptions(RouteOptions routeOptions) {
        if (routeOptions == null) {
            throw new MissingFormatArgumentException("Using the default milestones requires the directions route to include the route options object.");
        }
    }

    private static void checkInvalidVoiceInstructions(RouteOptions routeOptions) {
        boolean invalidVoiceInstructions;
        Boolean instructions = routeOptions.voiceInstructions();
        boolean bl = invalidVoiceInstructions = instructions == null || instructions == false;
        if (invalidVoiceInstructions) {
            throw new MissingFormatArgumentException("Using the default milestones requires the directions route to be requested with voice instructions enabled.");
        }
    }

    private static void checkInvalidBannerInstructions(RouteOptions routeOptions) {
        boolean invalidBannerInstructions;
        Boolean instructions = routeOptions.bannerInstructions();
        boolean bl = invalidBannerInstructions = instructions == null || instructions == false;
        if (invalidBannerInstructions) {
            throw new MissingFormatArgumentException("Using the default milestones requires the directions route to be requested with banner instructions enabled.");
        }
    }
}

