/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.routeprogress;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.auto.value.AutoValue;
import com.mapbox.api.directions.v5.models.LegStep;
import com.mapbox.api.directions.v5.models.RouteLeg;
import com.mapbox.geojson.Point;
import com.mapbox.services.android.navigation.v5.routeprogress.AutoValue_RouteLegProgress;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteStepProgress;
import java.util.List;

@AutoValue
public abstract class RouteLegProgress {
    public abstract int stepIndex();

    public double distanceTraveled() {
        double distanceTraveled = this.routeLeg().distance() - this.distanceRemaining();
        if (distanceTraveled < 0.0) {
            distanceTraveled = 0.0;
        }
        return distanceTraveled;
    }

    public abstract double distanceRemaining();

    public abstract double durationRemaining();

    public float fractionTraveled() {
        float fractionTraveled = 1.0f;
        if (this.routeLeg().distance() > 0.0 && (fractionTraveled = (float)(this.distanceTraveled() / this.routeLeg().distance())) < 0.0f) {
            fractionTraveled = 0.0f;
        }
        return fractionTraveled;
    }

    @Nullable
    public LegStep previousStep() {
        if (this.stepIndex() == 0) {
            return null;
        }
        return (LegStep)this.routeLeg().steps().get(this.stepIndex() - 1);
    }

    @NonNull
    public abstract LegStep currentStep();

    @Nullable
    public LegStep upComingStep() {
        if (this.routeLeg().steps().size() - 1 > this.stepIndex()) {
            return (LegStep)this.routeLeg().steps().get(this.stepIndex() + 1);
        }
        return null;
    }

    @Nullable
    public LegStep followOnStep() {
        if (this.routeLeg().steps().size() - 2 > this.stepIndex()) {
            return (LegStep)this.routeLeg().steps().get(this.stepIndex() + 2);
        }
        return null;
    }

    public abstract RouteStepProgress currentStepProgress();

    public abstract List<Point> currentStepPoints();

    @Nullable
    public abstract List<Point> upcomingStepPoints();

    abstract RouteLeg routeLeg();

    abstract double stepDistanceRemaining();

    public static Builder builder() {
        return new AutoValue_RouteLegProgress.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract Builder routeLeg(RouteLeg var1);

        abstract Builder currentStep(LegStep var1);

        abstract LegStep currentStep();

        abstract Builder stepIndex(int var1);

        abstract Builder durationRemaining(double var1);

        abstract Builder stepDistanceRemaining(double var1);

        abstract double stepDistanceRemaining();

        abstract Builder distanceRemaining(double var1);

        abstract Builder currentStepProgress(RouteStepProgress var1);

        abstract Builder currentStepPoints(List<Point> var1);

        abstract Builder upcomingStepPoints(@Nullable List<Point> var1);

        abstract RouteLegProgress autoBuild();

        public RouteLegProgress build() {
            RouteStepProgress stepProgress = RouteStepProgress.builder().step(this.currentStep()).distanceRemaining(this.stepDistanceRemaining()).build();
            this.currentStepProgress(stepProgress);
            return this.autoBuild();
        }
    }
}

