/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.routeprogress;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mapbox.api.directions.v5.models.LegStep;
import com.mapbox.api.directions.v5.models.RouteLeg;
import com.mapbox.geojson.Point;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteLegProgress;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteStepProgress;
import java.util.List;

final class AutoValue_RouteLegProgress
extends RouteLegProgress {
    private final int stepIndex;
    private final double distanceRemaining;
    private final double durationRemaining;
    private final LegStep currentStep;
    private final RouteStepProgress currentStepProgress;
    private final List<Point> currentStepPoints;
    private final List<Point> upcomingStepPoints;
    private final RouteLeg routeLeg;
    private final double stepDistanceRemaining;

    private AutoValue_RouteLegProgress(int stepIndex, double distanceRemaining, double durationRemaining, LegStep currentStep, RouteStepProgress currentStepProgress, List<Point> currentStepPoints, @Nullable List<Point> upcomingStepPoints, RouteLeg routeLeg, double stepDistanceRemaining) {
        this.stepIndex = stepIndex;
        this.distanceRemaining = distanceRemaining;
        this.durationRemaining = durationRemaining;
        this.currentStep = currentStep;
        this.currentStepProgress = currentStepProgress;
        this.currentStepPoints = currentStepPoints;
        this.upcomingStepPoints = upcomingStepPoints;
        this.routeLeg = routeLeg;
        this.stepDistanceRemaining = stepDistanceRemaining;
    }

    @Override
    public int stepIndex() {
        return this.stepIndex;
    }

    @Override
    public double distanceRemaining() {
        return this.distanceRemaining;
    }

    @Override
    public double durationRemaining() {
        return this.durationRemaining;
    }

    @Override
    @NonNull
    public LegStep currentStep() {
        return this.currentStep;
    }

    @Override
    public RouteStepProgress currentStepProgress() {
        return this.currentStepProgress;
    }

    @Override
    public List<Point> currentStepPoints() {
        return this.currentStepPoints;
    }

    @Override
    @Nullable
    public List<Point> upcomingStepPoints() {
        return this.upcomingStepPoints;
    }

    @Override
    RouteLeg routeLeg() {
        return this.routeLeg;
    }

    @Override
    double stepDistanceRemaining() {
        return this.stepDistanceRemaining;
    }

    public String toString() {
        return "RouteLegProgress{stepIndex=" + this.stepIndex + ", distanceRemaining=" + this.distanceRemaining + ", durationRemaining=" + this.durationRemaining + ", currentStep=" + this.currentStep + ", currentStepProgress=" + this.currentStepProgress + ", currentStepPoints=" + this.currentStepPoints + ", upcomingStepPoints=" + this.upcomingStepPoints + ", routeLeg=" + this.routeLeg + ", stepDistanceRemaining=" + this.stepDistanceRemaining + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RouteLegProgress) {
            RouteLegProgress that = (RouteLegProgress)o;
            return this.stepIndex == that.stepIndex() && Double.doubleToLongBits(this.distanceRemaining) == Double.doubleToLongBits(that.distanceRemaining()) && Double.doubleToLongBits(this.durationRemaining) == Double.doubleToLongBits(that.durationRemaining()) && this.currentStep.equals(that.currentStep()) && this.currentStepProgress.equals(that.currentStepProgress()) && this.currentStepPoints.equals(that.currentStepPoints()) && (this.upcomingStepPoints == null ? that.upcomingStepPoints() == null : this.upcomingStepPoints.equals(that.upcomingStepPoints())) && this.routeLeg.equals(that.routeLeg()) && Double.doubleToLongBits(this.stepDistanceRemaining) == Double.doubleToLongBits(that.stepDistanceRemaining());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.stepIndex;
        h$ *= 1000003;
        h$ ^= (int)(Double.doubleToLongBits(this.distanceRemaining) >>> 32 ^ Double.doubleToLongBits(this.distanceRemaining));
        h$ *= 1000003;
        h$ ^= (int)(Double.doubleToLongBits(this.durationRemaining) >>> 32 ^ Double.doubleToLongBits(this.durationRemaining));
        h$ *= 1000003;
        h$ ^= this.currentStep.hashCode();
        h$ *= 1000003;
        h$ ^= this.currentStepProgress.hashCode();
        h$ *= 1000003;
        h$ ^= this.currentStepPoints.hashCode();
        h$ *= 1000003;
        h$ ^= this.upcomingStepPoints == null ? 0 : this.upcomingStepPoints.hashCode();
        h$ *= 1000003;
        h$ ^= this.routeLeg.hashCode();
        h$ *= 1000003;
        return h$ ^= (int)(Double.doubleToLongBits(this.stepDistanceRemaining) >>> 32 ^ Double.doubleToLongBits(this.stepDistanceRemaining));
    }

    static final class Builder
    extends RouteLegProgress.Builder {
        private Integer stepIndex;
        private Double distanceRemaining;
        private Double durationRemaining;
        private LegStep currentStep;
        private RouteStepProgress currentStepProgress;
        private List<Point> currentStepPoints;
        private List<Point> upcomingStepPoints;
        private RouteLeg routeLeg;
        private Double stepDistanceRemaining;

        Builder() {
        }

        @Override
        RouteLegProgress.Builder stepIndex(int stepIndex) {
            this.stepIndex = stepIndex;
            return this;
        }

        @Override
        RouteLegProgress.Builder distanceRemaining(double distanceRemaining) {
            this.distanceRemaining = distanceRemaining;
            return this;
        }

        @Override
        RouteLegProgress.Builder durationRemaining(double durationRemaining) {
            this.durationRemaining = durationRemaining;
            return this;
        }

        @Override
        RouteLegProgress.Builder currentStep(LegStep currentStep) {
            if (currentStep == null) {
                throw new NullPointerException("Null currentStep");
            }
            this.currentStep = currentStep;
            return this;
        }

        @Override
        LegStep currentStep() {
            if (this.currentStep == null) {
                throw new IllegalStateException("Property \"currentStep\" has not been set");
            }
            return this.currentStep;
        }

        @Override
        RouteLegProgress.Builder currentStepProgress(RouteStepProgress currentStepProgress) {
            if (currentStepProgress == null) {
                throw new NullPointerException("Null currentStepProgress");
            }
            this.currentStepProgress = currentStepProgress;
            return this;
        }

        @Override
        RouteLegProgress.Builder currentStepPoints(List<Point> currentStepPoints) {
            if (currentStepPoints == null) {
                throw new NullPointerException("Null currentStepPoints");
            }
            this.currentStepPoints = currentStepPoints;
            return this;
        }

        @Override
        RouteLegProgress.Builder upcomingStepPoints(@Nullable List<Point> upcomingStepPoints) {
            this.upcomingStepPoints = upcomingStepPoints;
            return this;
        }

        @Override
        RouteLegProgress.Builder routeLeg(RouteLeg routeLeg) {
            if (routeLeg == null) {
                throw new NullPointerException("Null routeLeg");
            }
            this.routeLeg = routeLeg;
            return this;
        }

        @Override
        RouteLegProgress.Builder stepDistanceRemaining(double stepDistanceRemaining) {
            this.stepDistanceRemaining = stepDistanceRemaining;
            return this;
        }

        @Override
        double stepDistanceRemaining() {
            if (this.stepDistanceRemaining == null) {
                throw new IllegalStateException("Property \"stepDistanceRemaining\" has not been set");
            }
            return this.stepDistanceRemaining;
        }

        @Override
        RouteLegProgress autoBuild() {
            String missing = "";
            if (this.stepIndex == null) {
                missing = missing + " stepIndex";
            }
            if (this.distanceRemaining == null) {
                missing = missing + " distanceRemaining";
            }
            if (this.durationRemaining == null) {
                missing = missing + " durationRemaining";
            }
            if (this.currentStep == null) {
                missing = missing + " currentStep";
            }
            if (this.currentStepProgress == null) {
                missing = missing + " currentStepProgress";
            }
            if (this.currentStepPoints == null) {
                missing = missing + " currentStepPoints";
            }
            if (this.routeLeg == null) {
                missing = missing + " routeLeg";
            }
            if (this.stepDistanceRemaining == null) {
                missing = missing + " stepDistanceRemaining";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_RouteLegProgress(this.stepIndex, this.distanceRemaining, this.durationRemaining, this.currentStep, this.currentStepProgress, this.currentStepPoints, this.upcomingStepPoints, this.routeLeg, this.stepDistanceRemaining);
        }
    }
}

