/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation.metrics;

import android.location.Location;
import android.support.annotation.Keep;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.auto.value.AutoValue;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.api.directions.v5.models.RouteLeg;
import com.mapbox.geojson.utils.PolylineUtils;
import com.mapbox.services.android.navigation.v5.navigation.metrics.AutoValue_SessionState;
import com.mapbox.services.android.navigation.v5.routeprogress.MetricsRouteProgress;
import java.util.Date;
import java.util.List;

@Keep
@AutoValue
public abstract class SessionState {
    public String originalGeometry() {
        if (this.originalDirectionRoute() == null || TextUtils.isEmpty((CharSequence)this.originalDirectionRoute().geometry())) {
            return "";
        }
        List geometryPositions = PolylineUtils.decode((String)this.originalDirectionRoute().geometry(), (int)6);
        return PolylineUtils.encode((List)geometryPositions, (int)5);
    }

    public int originalDistance() {
        if (this.originalDirectionRoute() == null) {
            return 0;
        }
        return this.originalDirectionRoute().distance().intValue();
    }

    public int originalStepCount() {
        if (this.originalDirectionRoute() == null) {
            return 0;
        }
        int stepCount = 0;
        for (RouteLeg leg : this.originalDirectionRoute().legs()) {
            stepCount += leg.steps().size();
        }
        return stepCount;
    }

    public int originalDuration() {
        if (this.originalDirectionRoute() == null) {
            return 0;
        }
        return this.originalDirectionRoute().duration().intValue();
    }

    public int currentStepCount() {
        if (this.currentDirectionRoute() == null) {
            return 0;
        }
        int stepCount = 0;
        for (RouteLeg leg : this.currentDirectionRoute().legs()) {
            stepCount += leg.steps().size();
        }
        return stepCount;
    }

    public String currentGeometry() {
        if (this.currentDirectionRoute() == null || TextUtils.isEmpty((CharSequence)this.currentDirectionRoute().geometry())) {
            return "";
        }
        List geometryPositions = PolylineUtils.decode((String)this.currentDirectionRoute().geometry(), (int)6);
        return PolylineUtils.encode((List)geometryPositions, (int)5);
    }

    public abstract int secondsSinceLastReroute();

    public abstract MetricsRouteProgress eventRouteProgress();

    @Nullable
    public abstract Location eventLocation();

    @Nullable
    public abstract Date eventDate();

    public abstract double eventRouteDistanceCompleted();

    @Nullable
    public abstract List<Location> afterEventLocations();

    @Nullable
    public abstract List<Location> beforeEventLocations();

    @Nullable
    public abstract DirectionsRoute originalDirectionRoute();

    @Nullable
    public abstract DirectionsRoute currentDirectionRoute();

    public abstract String sessionIdentifier();

    public abstract String tripIdentifier();

    @Nullable
    public abstract String originalRequestIdentifier();

    @Nullable
    public abstract String requestIdentifier();

    public abstract boolean mockLocation();

    public abstract int rerouteCount();

    @Nullable
    public abstract Date startTimestamp();

    @Nullable
    public abstract Date arrivalTimestamp();

    public abstract String locationEngineName();

    public abstract int percentInForeground();

    public abstract int percentInPortrait();

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_SessionState.Builder().eventRouteDistanceCompleted(0.0).sessionIdentifier("").tripIdentifier("").mockLocation(false).rerouteCount(0).secondsSinceLastReroute(-1).eventRouteProgress(new MetricsRouteProgress(null)).locationEngineName("").percentInForeground(100).percentInPortrait(100);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder eventRouteProgress(MetricsRouteProgress var1);

        public abstract Builder eventLocation(@Nullable Location var1);

        public abstract Builder eventDate(@Nullable Date var1);

        public abstract Builder eventRouteDistanceCompleted(double var1);

        public abstract Builder afterEventLocations(@Nullable List<Location> var1);

        public abstract Builder beforeEventLocations(@Nullable List<Location> var1);

        public abstract Builder originalDirectionRoute(@Nullable DirectionsRoute var1);

        public abstract Builder currentDirectionRoute(@Nullable DirectionsRoute var1);

        public abstract Builder sessionIdentifier(String var1);

        public abstract Builder tripIdentifier(String var1);

        public abstract Builder originalRequestIdentifier(@Nullable String var1);

        public abstract Builder requestIdentifier(@Nullable String var1);

        public abstract Builder secondsSinceLastReroute(int var1);

        public abstract Builder mockLocation(boolean var1);

        public abstract Builder rerouteCount(int var1);

        public abstract Builder startTimestamp(Date var1);

        public abstract Builder arrivalTimestamp(@Nullable Date var1);

        public abstract Builder locationEngineName(String var1);

        public abstract Builder percentInForeground(int var1);

        public abstract Builder percentInPortrait(int var1);

        public abstract SessionState build();
    }
}

