/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation.metrics;

import android.content.Context;
import android.support.annotation.Keep;
import com.mapbox.android.telemetry.TelemetryUtils;
import com.mapbox.services.android.navigation.v5.navigation.metrics.NavigationUtils;

@Keep
public class PhoneState {
    private final int volumeLevel;
    private final int batteryLevel;
    private final int screenBrightness;
    private final boolean batteryPluggedIn;
    private final String connectivity;
    private final String audioType;
    private final String applicationState;
    private final String created;
    private final String feedbackId;
    private final String userId;

    public PhoneState(Context context) {
        this.volumeLevel = NavigationUtils.obtainVolumeLevel(context);
        this.batteryLevel = TelemetryUtils.obtainBatteryLevel((Context)context);
        this.screenBrightness = NavigationUtils.obtainScreenBrightness(context);
        this.batteryPluggedIn = TelemetryUtils.isPluggedIn((Context)context);
        this.connectivity = TelemetryUtils.obtainCellularNetworkType((Context)context);
        this.audioType = NavigationUtils.obtainAudioType(context);
        this.applicationState = TelemetryUtils.obtainApplicationState((Context)context);
        this.created = TelemetryUtils.obtainCurrentDate();
        this.feedbackId = TelemetryUtils.obtainUniversalUniqueIdentifier();
        this.userId = TelemetryUtils.retrieveVendorId();
    }

    String getUserId() {
        return this.userId;
    }

    int getVolumeLevel() {
        return this.volumeLevel;
    }

    int getBatteryLevel() {
        return this.batteryLevel;
    }

    int getScreenBrightness() {
        return this.screenBrightness;
    }

    boolean isBatteryPluggedIn() {
        return this.batteryPluggedIn;
    }

    String getConnectivity() {
        return this.connectivity;
    }

    String getAudioType() {
        return this.audioType;
    }

    String getApplicationState() {
        return this.applicationState;
    }

    String getCreated() {
        return this.created;
    }

    String getFeedbackId() {
        return this.feedbackId;
    }
}

