/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation.metrics;

import android.content.ContentResolver;
import android.content.Context;
import android.media.AudioManager;
import android.provider.Settings;
import com.mapbox.services.android.navigation.v5.navigation.metrics.audio.AudioTypeChain;
import com.mapbox.services.android.navigation.v5.navigation.metrics.audio.AudioTypeResolver;

class NavigationUtils {
    private static final double PERCENT_NORMALIZER = 100.0;
    private static final double SCREEN_BRIGHTNESS_MAX = 255.0;
    private static final int BRIGHTNESS_EXCEPTION_VALUE = -1;

    NavigationUtils() {
    }

    static int obtainVolumeLevel(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        return (int)Math.floor(100.0 * (double)audioManager.getStreamVolume(3) / (double)audioManager.getStreamMaxVolume(3));
    }

    static int obtainScreenBrightness(Context context) {
        int screenBrightness;
        try {
            screenBrightness = Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"screen_brightness");
            screenBrightness = NavigationUtils.calculateScreenBrightnessPercentage(screenBrightness);
        }
        catch (Settings.SettingNotFoundException exception) {
            screenBrightness = -1;
        }
        return screenBrightness;
    }

    static String obtainAudioType(Context context) {
        AudioTypeChain audioTypeChain = new AudioTypeChain();
        AudioTypeResolver setupChain = audioTypeChain.setup();
        return setupChain.obtainAudioType(context);
    }

    private static int calculateScreenBrightnessPercentage(int screenBrightness) {
        return (int)Math.floor(100.0 * (double)screenBrightness / 255.0);
    }
}

