/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation.metrics;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import com.mapbox.services.android.navigation.v5.routeprogress.MetricsRouteProgress;

@Keep
class NavigationStepData {
    private final String upcomingInstruction;
    private final String upcomingType;
    private final String upcomingModifier;
    private final String upcomingName;
    private final String previousInstruction;
    private final String previousType;
    private final String previousModifier;
    private final String previousName;
    private int distance;
    private int duration;
    private int distanceRemaining;
    private int durationRemaining;

    NavigationStepData(@NonNull MetricsRouteProgress metricsRouteProgress) {
        this.upcomingInstruction = metricsRouteProgress.getUpcomingStepInstruction();
        this.upcomingModifier = metricsRouteProgress.getUpcomingStepModifier();
        this.upcomingName = metricsRouteProgress.getUpcomingStepName();
        this.upcomingType = metricsRouteProgress.getUpcomingStepType();
        this.previousInstruction = metricsRouteProgress.getPreviousStepInstruction();
        this.previousModifier = metricsRouteProgress.getPreviousStepModifier();
        this.previousType = metricsRouteProgress.getPreviousStepType();
        this.previousName = metricsRouteProgress.getPreviousStepName();
        this.distance = metricsRouteProgress.getCurrentStepDistance();
        this.duration = metricsRouteProgress.getCurrentStepDuration();
        this.distanceRemaining = metricsRouteProgress.getCurrentStepDistanceRemaining();
        this.durationRemaining = metricsRouteProgress.getCurrentStepDurationRemaining();
    }

    String getUpcomingInstruction() {
        return this.upcomingInstruction;
    }

    String getUpcomingType() {
        return this.upcomingType;
    }

    String getUpcomingModifier() {
        return this.upcomingModifier;
    }

    String getUpcomingName() {
        return this.upcomingName;
    }

    String getPreviousInstruction() {
        return this.previousInstruction;
    }

    String getPreviousType() {
        return this.previousType;
    }

    String getPreviousModifier() {
        return this.previousModifier;
    }

    String getPreviousName() {
        return this.previousName;
    }

    int getDistance() {
        return this.distance;
    }

    int getDuration() {
        return this.duration;
    }

    public int getDistanceRemaining() {
        return this.distanceRemaining;
    }

    public int getDurationRemaining() {
        return this.durationRemaining;
    }
}

