/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation.metrics;

import android.annotation.SuppressLint;
import android.location.Location;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import com.mapbox.services.android.navigation.v5.navigation.metrics.NavigationEvent;
import com.mapbox.services.android.navigation.v5.navigation.metrics.NavigationStepData;
import com.mapbox.services.android.navigation.v5.navigation.metrics.PhoneState;
import com.mapbox.services.android.navigation.v5.navigation.metrics.RerouteEvent;
import com.mapbox.services.android.navigation.v5.routeprogress.MetricsRouteProgress;

@Keep
@SuppressLint(value={"ParcelCreator"})
public class NavigationRerouteEvent
extends NavigationEvent {
    private static final String NAVIGATION_REROUTE = "navigation.reroute";
    private final int newDistanceRemaining;
    private final int newDurationRemaining;
    private final String feedbackId;
    private final String newGeometry;
    private int secondsSinceLastReroute;
    private Location[] locationsBefore;
    private Location[] locationsAfter;
    private String screenshot;
    private NavigationStepData step;

    NavigationRerouteEvent(@NonNull PhoneState phoneState, @NonNull RerouteEvent rerouteEvent, @NonNull MetricsRouteProgress metricsRouteProgress) {
        super(phoneState);
        this.newDistanceRemaining = rerouteEvent.getNewDistanceRemaining();
        this.newDurationRemaining = rerouteEvent.getNewDurationRemaining();
        this.newGeometry = rerouteEvent.getNewRouteGeometry();
        this.feedbackId = phoneState.getFeedbackId();
        this.step = new NavigationStepData(metricsRouteProgress);
    }

    @Override
    String getEventName() {
        return NAVIGATION_REROUTE;
    }

    NavigationStepData getStep() {
        return this.step;
    }

    int getNewDistanceRemaining() {
        return this.newDistanceRemaining;
    }

    int getNewDurationRemaining() {
        return this.newDurationRemaining;
    }

    String getNewGeometry() {
        return this.newGeometry;
    }

    int getSecondsSinceLastReroute() {
        return this.secondsSinceLastReroute;
    }

    void setSecondsSinceLastReroute(int secondsSinceLastReroute) {
        this.secondsSinceLastReroute = secondsSinceLastReroute;
    }

    Location[] getLocationsBefore() {
        return this.locationsBefore;
    }

    void setLocationsBefore(Location[] locationsBefore) {
        this.locationsBefore = locationsBefore;
    }

    Location[] getLocationsAfter() {
        return this.locationsAfter;
    }

    void setLocationsAfter(Location[] locationsAfter) {
        this.locationsAfter = locationsAfter;
    }

    String getFeedbackId() {
        return this.feedbackId;
    }

    String getScreenshot() {
        return this.screenshot;
    }

    void setScreenshot(String screenshot) {
        this.screenshot = screenshot;
    }
}

