/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation.metrics;

import android.annotation.SuppressLint;
import android.location.Location;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import com.mapbox.services.android.navigation.v5.navigation.metrics.NavigationEvent;
import com.mapbox.services.android.navigation.v5.navigation.metrics.NavigationStepData;
import com.mapbox.services.android.navigation.v5.navigation.metrics.PhoneState;
import com.mapbox.services.android.navigation.v5.routeprogress.MetricsRouteProgress;

@Keep
@SuppressLint(value={"ParcelCreator"})
class NavigationFeedbackEvent
extends NavigationEvent {
    private static final String NAVIGATION_FEEDBACK = "navigation.feedback";
    private final String userId;
    private String feedbackType;
    private String source;
    private String description;
    private Location[] locationsBefore;
    private Location[] locationsAfter;
    private final String feedbackId;
    private String screenshot;
    private NavigationStepData step;

    NavigationFeedbackEvent(PhoneState phoneState, @NonNull MetricsRouteProgress metricsRouteProgress) {
        super(phoneState);
        this.userId = phoneState.getUserId();
        this.feedbackId = phoneState.getFeedbackId();
        this.step = new NavigationStepData(metricsRouteProgress);
    }

    @Override
    String getEventName() {
        return NAVIGATION_FEEDBACK;
    }

    NavigationStepData getStep() {
        return this.step;
    }

    String getUserId() {
        return this.userId;
    }

    String getFeedbackType() {
        return this.feedbackType;
    }

    void setFeedbackType(String feedbackType) {
        this.feedbackType = feedbackType;
    }

    String getSource() {
        return this.source;
    }

    void setSource(String source) {
        this.source = source;
    }

    String getDescription() {
        return this.description;
    }

    void setDescription(String description) {
        this.description = description;
    }

    Location[] getLocationsBefore() {
        return this.locationsBefore;
    }

    void setLocationsBefore(Location[] locationsBefore) {
        this.locationsBefore = locationsBefore;
    }

    Location[] getLocationsAfter() {
        return this.locationsAfter;
    }

    void setLocationsAfter(Location[] locationsAfter) {
        this.locationsAfter = locationsAfter;
    }

    String getFeedbackId() {
        return this.feedbackId;
    }

    String getScreenshot() {
        return this.screenshot;
    }

    void setScreenshot(String screenshot) {
        this.screenshot = screenshot;
    }
}

