/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation.metrics;

import android.os.Build;
import android.os.Parcel;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import com.mapbox.android.telemetry.Event;
import com.mapbox.services.android.navigation.v5.navigation.metrics.PhoneState;

@Keep
abstract class NavigationEvent
extends Event {
    private static final String OPERATING_SYSTEM = "Android - " + Build.VERSION.RELEASE;
    private final String operatingSystem = OPERATING_SYSTEM;
    private final String device = Build.MODEL;
    private final String sdkVersion = "0.42.6.1";
    private final String event;
    private final String created;
    private final String applicationState;
    private final String connectivity;
    private final boolean batteryPluggedIn;
    private final int volumeLevel;
    private final int screenBrightness;
    private final int batteryLevel;
    private String startTimestamp;
    private String sdkIdentifier;
    private String sessionIdentifier;
    private String geometry;
    private String profile;
    private String originalRequestIdentifier;
    private String requestIdentifier;
    private String originalGeometry;
    private String audioType;
    private String locationEngine;
    private String tripIdentifier;
    private double lat;
    private double lng;
    private boolean simulation;
    private int absoluteDistanceToDestination;
    private int percentTimeInPortrait;
    private int percentTimeInForeground;
    private int distanceCompleted;
    private int distanceRemaining;
    private int durationRemaining;
    private int eventVersion;
    private int estimatedDistance;
    private int estimatedDuration;
    private int rerouteCount;
    private int originalEstimatedDistance;
    private int originalEstimatedDuration;
    private int stepCount;
    private int originalStepCount;
    private int legIndex;
    private int legCount;
    private int stepIndex;
    private int voiceIndex;
    private int bannerIndex;
    private int totalStepCount;

    NavigationEvent(@NonNull PhoneState phoneState) {
        this.created = phoneState.getCreated();
        this.volumeLevel = phoneState.getVolumeLevel();
        this.batteryLevel = phoneState.getBatteryLevel();
        this.screenBrightness = phoneState.getScreenBrightness();
        this.batteryPluggedIn = phoneState.isBatteryPluggedIn();
        this.connectivity = phoneState.getConnectivity();
        this.audioType = phoneState.getAudioType();
        this.applicationState = phoneState.getApplicationState();
        this.event = this.getEventName();
    }

    abstract String getEventName();

    String getEvent() {
        return this.event;
    }

    String getOperatingSystem() {
        return this.operatingSystem;
    }

    String getDevice() {
        return this.device;
    }

    String getCreated() {
        return this.created;
    }

    String getApplicationState() {
        return this.applicationState;
    }

    String getConnectivity() {
        return this.connectivity;
    }

    boolean isBatteryPluggedIn() {
        return this.batteryPluggedIn;
    }

    int getVolumeLevel() {
        return this.volumeLevel;
    }

    int getScreenBrightness() {
        return this.screenBrightness;
    }

    int getBatteryLevel() {
        return this.batteryLevel;
    }

    String getStartTimestamp() {
        return this.startTimestamp;
    }

    void setStartTimestamp(String startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    String getSdkIdentifier() {
        return this.sdkIdentifier;
    }

    void setSdkIdentifier(String sdkIdentifier) {
        this.sdkIdentifier = sdkIdentifier;
    }

    String getSdkVersion() {
        return "0.42.6.1";
    }

    String getSessionIdentifier() {
        return this.sessionIdentifier;
    }

    void setSessionIdentifier(String sessionIdentifier) {
        this.sessionIdentifier = sessionIdentifier;
    }

    String getGeometry() {
        return this.geometry;
    }

    void setGeometry(String geometry) {
        this.geometry = geometry;
    }

    String getProfile() {
        return this.profile;
    }

    void setProfile(String profile) {
        this.profile = profile;
    }

    String getOriginalRequestIdentifier() {
        return this.originalRequestIdentifier;
    }

    void setOriginalRequestIdentifier(String originalRequestIdentifier) {
        this.originalRequestIdentifier = originalRequestIdentifier;
    }

    String getRequestIdentifier() {
        return this.requestIdentifier;
    }

    void setRequestIdentifier(String requestIdentifier) {
        this.requestIdentifier = requestIdentifier;
    }

    String getOriginalGeometry() {
        return this.originalGeometry;
    }

    void setOriginalGeometry(String originalGeometry) {
        this.originalGeometry = originalGeometry;
    }

    String getAudioType() {
        return this.audioType;
    }

    void setAudioType(String audioType) {
        this.audioType = audioType;
    }

    String getLocationEngine() {
        return this.locationEngine;
    }

    void setLocationEngine(String locationEngine) {
        this.locationEngine = locationEngine;
    }

    String getTripIdentifier() {
        return this.tripIdentifier;
    }

    void setTripIdentifier(String tripIdentifier) {
        this.tripIdentifier = tripIdentifier;
    }

    double getLat() {
        return this.lat;
    }

    void setLat(double lat) {
        this.lat = lat;
    }

    double getLng() {
        return this.lng;
    }

    void setLng(double lng) {
        this.lng = lng;
    }

    boolean isSimulation() {
        return this.simulation;
    }

    void setSimulation(boolean simulation) {
        this.simulation = simulation;
    }

    int getAbsoluteDistanceToDestination() {
        return this.absoluteDistanceToDestination;
    }

    void setAbsoluteDistanceToDestination(int absoluteDistanceToDestination) {
        this.absoluteDistanceToDestination = absoluteDistanceToDestination;
    }

    int getPercentTimeInPortrait() {
        return this.percentTimeInPortrait;
    }

    void setPercentTimeInPortrait(int percentTimeInPortrait) {
        this.percentTimeInPortrait = percentTimeInPortrait;
    }

    int getPercentTimeInForeground() {
        return this.percentTimeInForeground;
    }

    void setPercentTimeInForeground(int percentTimeInForeground) {
        this.percentTimeInForeground = percentTimeInForeground;
    }

    int getDistanceCompleted() {
        return this.distanceCompleted;
    }

    void setDistanceCompleted(int distanceCompleted) {
        this.distanceCompleted = distanceCompleted;
    }

    int getDistanceRemaining() {
        return this.distanceRemaining;
    }

    void setDistanceRemaining(int distanceRemaining) {
        this.distanceRemaining = distanceRemaining;
    }

    int getDurationRemaining() {
        return this.durationRemaining;
    }

    void setDurationRemaining(int durationRemaining) {
        this.durationRemaining = durationRemaining;
    }

    int getEventVersion() {
        return this.eventVersion;
    }

    void setEventVersion(int eventVersion) {
        this.eventVersion = eventVersion;
    }

    int getEstimatedDistance() {
        return this.estimatedDistance;
    }

    void setEstimatedDistance(int estimatedDistance) {
        this.estimatedDistance = estimatedDistance;
    }

    int getEstimatedDuration() {
        return this.estimatedDuration;
    }

    void setEstimatedDuration(int estimatedDuration) {
        this.estimatedDuration = estimatedDuration;
    }

    int getRerouteCount() {
        return this.rerouteCount;
    }

    void setRerouteCount(int rerouteCount) {
        this.rerouteCount = rerouteCount;
    }

    int getOriginalEstimatedDistance() {
        return this.originalEstimatedDistance;
    }

    void setOriginalEstimatedDistance(int originalEstimatedDistance) {
        this.originalEstimatedDistance = originalEstimatedDistance;
    }

    int getOriginalEstimatedDuration() {
        return this.originalEstimatedDuration;
    }

    void setOriginalEstimatedDuration(int originalEstimatedDuration) {
        this.originalEstimatedDuration = originalEstimatedDuration;
    }

    int getStepCount() {
        return this.stepCount;
    }

    void setStepCount(int stepCount) {
        this.stepCount = stepCount;
    }

    int getOriginalStepCount() {
        return this.originalStepCount;
    }

    void setOriginalStepCount(int originalStepCount) {
        this.originalStepCount = originalStepCount;
    }

    int getLegIndex() {
        return this.legIndex;
    }

    void setLegIndex(int legIndex) {
        this.legIndex = legIndex;
    }

    int getLegCount() {
        return this.legCount;
    }

    void setLegCount(int legCount) {
        this.legCount = legCount;
    }

    int getStepIndex() {
        return this.stepIndex;
    }

    void setStepIndex(int stepIndex) {
        this.stepIndex = stepIndex;
    }

    int getVoiceIndex() {
        return this.voiceIndex;
    }

    void setVoiceIndex(int voiceIndex) {
        this.voiceIndex = voiceIndex;
    }

    int getBannerIndex() {
        return this.bannerIndex;
    }

    void setBannerIndex(int bannerIndex) {
        this.bannerIndex = bannerIndex;
    }

    int getTotalStepCount() {
        return this.totalStepCount;
    }

    void setTotalStepCount(int totalStepCount) {
        this.totalStepCount = totalStepCount;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
    }
}

