/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation.metrics;

import android.support.annotation.Keep;
import com.mapbox.android.telemetry.TelemetryUtils;
import com.mapbox.services.android.navigation.v5.navigation.metrics.SessionState;
import com.mapbox.services.android.navigation.v5.navigation.metrics.TelemetryEvent;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@Keep
public class FeedbackEvent
implements TelemetryEvent {
    public static final String FEEDBACK_TYPE_GENERAL_ISSUE = "general";
    public static final String FEEDBACK_TYPE_ACCIDENT = "accident";
    public static final String FEEDBACK_TYPE_HAZARD = "hazard";
    public static final String FEEDBACK_TYPE_ROAD_CLOSED = "road_closed";
    public static final String FEEDBACK_TYPE_NOT_ALLOWED = "not_allowed";
    public static final String FEEDBACK_TYPE_ROUTING_ERROR = "routing_error";
    public static final String FEEDBACK_TYPE_MISSING_ROAD = "missing_road";
    public static final String FEEDBACK_TYPE_MISSING_EXIT = "missing_exit";
    public static final String FEEDBACK_TYPE_CONFUSING_INSTRUCTION = "confusing_instruction";
    public static final String FEEDBACK_TYPE_INACCURATE_GPS = "inaccurate_gps";
    public static final String FEEDBACK_SOURCE_REROUTE = "reroute";
    public static final String FEEDBACK_SOURCE_UI = "user";
    private String feedbackType;
    private String feedbackSource;
    private String screenshot;
    private String eventId;
    private String description;
    private SessionState feedbackSessionState;

    public FeedbackEvent(SessionState sessionState, String feedbackSource) {
        this.feedbackSessionState = sessionState;
        this.feedbackSource = feedbackSource;
        this.feedbackType = FEEDBACK_TYPE_GENERAL_ISSUE;
        this.eventId = TelemetryUtils.obtainUniversalUniqueIdentifier();
        this.screenshot = "";
    }

    @Override
    public String getEventId() {
        return this.eventId;
    }

    @Override
    public SessionState getSessionState() {
        return this.feedbackSessionState;
    }

    public String getFeedbackType() {
        return this.feedbackType;
    }

    public String getFeedbackSource() {
        return this.feedbackSource;
    }

    public String getScreenshot() {
        return this.screenshot;
    }

    public void setScreenshot(String screenshot) {
        this.screenshot = screenshot;
    }

    public void setFeedbackType(String feedbackType) {
        this.feedbackType = feedbackType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FeedbackSource {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FeedbackType {
    }
}

