/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.support.annotation.Nullable;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.api.directions.v5.models.LegStep;
import com.mapbox.api.directions.v5.models.RouteLeg;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.Point;
import com.mapbox.navigator.BannerInstruction;
import com.mapbox.navigator.NavigationStatus;
import com.mapbox.navigator.RouteState;
import com.mapbox.navigator.VoiceInstruction;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigator;
import com.mapbox.services.android.navigation.v5.navigation.NavigationHelper;
import com.mapbox.services.android.navigation.v5.routeprogress.CurrentLegAnnotation;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgressState;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgressStateMap;
import java.util.List;

class NavigationRouteProcessor {
    private static final int ONE_INDEX = 1;
    private static final double ONE_SECOND_IN_MILLISECONDS = 1000.0;
    private static final int FIRST_BANNER_INSTRUCTION = 0;
    private final RouteProgressStateMap progressStateMap = new RouteProgressStateMap();
    private RouteProgress previousRouteProgress;
    private NavigationStatus previousStatus;
    private DirectionsRoute route;
    private RouteLeg currentLeg;
    private LegStep currentStep;
    private List<Point> currentStepPoints;
    private List<Point> upcomingStepPoints;
    private CurrentLegAnnotation currentLegAnnotation;
    private Geometry routeGeometryWithBuffer;

    NavigationRouteProcessor() {
    }

    RouteProgress buildNewRouteProgress(MapboxNavigator navigator, NavigationStatus status, DirectionsRoute route) {
        this.previousStatus = status;
        this.updateRoute(route, navigator);
        return this.buildRouteProgressFrom(status, navigator);
    }

    void updatePreviousRouteProgress(RouteProgress routeProgress) {
        this.previousRouteProgress = routeProgress;
    }

    @Nullable
    RouteProgress retrievePreviousRouteProgress() {
        return this.previousRouteProgress;
    }

    @Nullable
    NavigationStatus retrievePreviousStatus() {
        return this.previousStatus;
    }

    private void updateRoute(DirectionsRoute route, MapboxNavigator navigator) {
        if (this.route == null || !this.route.equals(route)) {
            this.route = route;
            this.routeGeometryWithBuffer = navigator.retrieveRouteGeometryWithBuffer();
        }
    }

    private RouteProgress buildRouteProgressFrom(NavigationStatus status, MapboxNavigator navigator) {
        int legIndex = status.getLegIndex();
        int stepIndex = status.getStepIndex();
        int upcomingStepIndex = stepIndex + 1;
        this.updateSteps(this.route, legIndex, stepIndex);
        this.updateStepPoints(this.route, legIndex, stepIndex, upcomingStepIndex);
        double legDistanceRemaining = status.getRemainingLegDistance();
        double routeDistanceRemaining = NavigationHelper.routeDistanceRemaining(legDistanceRemaining, legIndex, this.route);
        double stepDistanceRemaining = status.getRemainingStepDistance();
        double legDurationRemaining = (double)status.getRemainingLegDuration() / 1000.0;
        this.currentLegAnnotation = NavigationHelper.createCurrentAnnotation(this.currentLegAnnotation, this.currentLeg, legDistanceRemaining);
        RouteState routeState = status.getRouteState();
        RouteProgressState currentRouteState = (RouteProgressState)((Object)this.progressStateMap.get(routeState));
        RouteProgress.Builder progressBuilder = RouteProgress.builder().distanceRemaining(routeDistanceRemaining).legDistanceRemaining(legDistanceRemaining).legDurationRemaining(legDurationRemaining).stepDistanceRemaining(stepDistanceRemaining).directionsRoute(this.route).currentStep(this.currentStep).currentStepPoints(this.currentStepPoints).upcomingStepPoints(this.upcomingStepPoints).stepIndex(stepIndex).legIndex(legIndex).inTunnel(status.getInTunnel()).currentState(currentRouteState);
        this.addRouteGeometries(progressBuilder);
        this.addVoiceInstructions(status, progressBuilder);
        this.addBannerInstructions(status, navigator, progressBuilder);
        this.addUpcomingStepPoints(progressBuilder);
        return progressBuilder.build();
    }

    private void updateSteps(DirectionsRoute route, int legIndex, int stepIndex) {
        List steps;
        List legs = route.legs();
        if (legIndex < legs.size()) {
            this.currentLeg = (RouteLeg)legs.get(legIndex);
        }
        if (stepIndex < (steps = this.currentLeg.steps()).size()) {
            this.currentStep = (LegStep)steps.get(stepIndex);
        }
    }

    private void updateStepPoints(DirectionsRoute route, int legIndex, int stepIndex, int upcomingStepIndex) {
        this.currentStepPoints = NavigationHelper.decodeStepPoints(route, this.currentStepPoints, legIndex, stepIndex);
        this.upcomingStepPoints = NavigationHelper.decodeStepPoints(route, null, legIndex, upcomingStepIndex);
    }

    private void addUpcomingStepPoints(RouteProgress.Builder progressBuilder) {
        if (this.upcomingStepPoints != null && !this.upcomingStepPoints.isEmpty()) {
            progressBuilder.upcomingStepPoints(this.upcomingStepPoints);
        }
    }

    private void addRouteGeometries(RouteProgress.Builder progressBuilder) {
        progressBuilder.routeGeometryWithBuffer(this.routeGeometryWithBuffer);
    }

    private void addVoiceInstructions(NavigationStatus status, RouteProgress.Builder progressBuilder) {
        VoiceInstruction voiceInstruction = status.getVoiceInstruction();
        progressBuilder.voiceInstruction(voiceInstruction);
    }

    private void addBannerInstructions(NavigationStatus status, MapboxNavigator navigator, RouteProgress.Builder progressBuilder) {
        BannerInstruction bannerInstruction = status.getBannerInstruction();
        if (status.getRouteState() == RouteState.INITIALIZED) {
            bannerInstruction = navigator.retrieveBannerInstruction(0);
        }
        progressBuilder.bannerInstruction(bannerInstruction);
    }
}

