/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.content.Context;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mapbox.api.directions.v5.MapboxDirections;
import com.mapbox.api.directions.v5.WalkingOptions;
import com.mapbox.api.directions.v5.models.DirectionsResponse;
import com.mapbox.api.directions.v5.models.RouteOptions;
import com.mapbox.core.utils.TextUtils;
import com.mapbox.geojson.Point;
import com.mapbox.services.android.navigation.v5.navigation.NavigationRouteCallback;
import com.mapbox.services.android.navigation.v5.navigation.NavigationRouteEventListener;
import com.mapbox.services.android.navigation.v5.navigation.NavigationRouteWaypoint;
import com.mapbox.services.android.navigation.v5.navigation.NavigationWalkingOptions;
import com.mapbox.services.android.navigation.v5.utils.LocaleUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import okhttp3.EventListener;
import okhttp3.Interceptor;
import retrofit2.Call;
import retrofit2.Callback;

public final class NavigationRoute {
    private final MapboxDirections mapboxDirections;
    private static final NavigationRouteEventListener EVENT_LISTENER = new NavigationRouteEventListener();

    NavigationRoute(MapboxDirections mapboxDirections) {
        this.mapboxDirections = mapboxDirections;
    }

    public static Builder builder(Context context) {
        return NavigationRoute.builder(context, new LocaleUtils());
    }

    static Builder builder(Context context, LocaleUtils localeUtils) {
        return new Builder().annotations("congestion", "distance").language(context, localeUtils).voiceUnits(context, localeUtils).profile("driving-traffic").continueStraight(true);
    }

    public void getRoute(Callback<DirectionsResponse> callback) {
        this.mapboxDirections.enqueueCall((Callback)new NavigationRouteCallback(EVENT_LISTENER, callback));
    }

    public Call<DirectionsResponse> getCall() {
        return this.mapboxDirections.cloneCall();
    }

    public void cancelCall() {
        if (!this.getCall().isExecuted()) {
            this.getCall().cancel();
        }
    }

    public static final class Builder {
        private static final String SEMICOLON = ";";
        private static final String COMMA = ",";
        private final MapboxDirections.Builder directionsBuilder;
        private final NavigationRouteEventListener eventListener;
        private NavigationRouteWaypoint origin;
        private NavigationRouteWaypoint destination;
        private List<NavigationRouteWaypoint> waypoints = new ArrayList<NavigationRouteWaypoint>();

        private Builder() {
            this(MapboxDirections.builder());
        }

        Builder(MapboxDirections.Builder directionsBuilder) {
            this.directionsBuilder = directionsBuilder;
            this.eventListener = EVENT_LISTENER;
        }

        public Builder user(@NonNull String user) {
            this.directionsBuilder.user(user);
            return this;
        }

        public Builder profile(@NonNull String profile) {
            this.directionsBuilder.profile(profile);
            return this;
        }

        public Builder origin(@NonNull Point origin) {
            this.origin = new NavigationRouteWaypoint(origin, null, null);
            return this;
        }

        public Builder origin(@NonNull Point origin, @Nullable Double angle, @Nullable Double tolerance) {
            this.origin = new NavigationRouteWaypoint(origin, angle, tolerance);
            return this;
        }

        public Builder destination(@NonNull Point destination) {
            this.destination = new NavigationRouteWaypoint(destination, null, null);
            return this;
        }

        public Builder destination(@NonNull Point destination, @Nullable Double angle, @Nullable Double tolerance) {
            this.destination = new NavigationRouteWaypoint(destination, angle, tolerance);
            return this;
        }

        public Builder addWaypoint(@NonNull Point waypoint) {
            this.waypoints.add(new NavigationRouteWaypoint(waypoint, null, null));
            return this;
        }

        public Builder addWaypoint(@NonNull Point waypoint, @Nullable Double angle, @Nullable Double tolerance) {
            this.waypoints.add(new NavigationRouteWaypoint(waypoint, angle, tolerance));
            return this;
        }

        public Builder alternatives(@Nullable Boolean alternatives) {
            this.directionsBuilder.alternatives(alternatives);
            return this;
        }

        public Builder language(Locale language) {
            this.directionsBuilder.language(language);
            return this;
        }

        Builder language(Context context, LocaleUtils localeUtils) {
            this.directionsBuilder.language(localeUtils.inferDeviceLocale(context));
            return this;
        }

        public Builder annotations(String ... annotations) {
            this.directionsBuilder.annotations(annotations);
            return this;
        }

        @Deprecated
        public Builder addBearing(@Nullable @FloatRange(from=0.0, to=360.0) Double angle, @Nullable @FloatRange(from=0.0, to=360.0) Double tolerance) {
            this.directionsBuilder.addBearing(angle, tolerance);
            return this;
        }

        public Builder radiuses(double ... radiuses) {
            this.directionsBuilder.radiuses(radiuses);
            return this;
        }

        public Builder voiceUnits(String voiceUnits) {
            this.directionsBuilder.voiceUnits(voiceUnits);
            return this;
        }

        Builder voiceUnits(Context context, LocaleUtils localeUtils) {
            this.directionsBuilder.voiceUnits(localeUtils.getUnitTypeForDeviceLocale(context));
            return this;
        }

        public Builder exclude(@Nullable String exclude) {
            this.directionsBuilder.exclude(exclude);
            return this;
        }

        public Builder clientAppName(@NonNull String clientAppName) {
            this.directionsBuilder.clientAppName(clientAppName);
            return this;
        }

        public Builder accessToken(@NonNull String accessToken) {
            this.directionsBuilder.accessToken(accessToken);
            return this;
        }

        public Builder baseUrl(String baseUrl) {
            this.directionsBuilder.baseUrl(baseUrl);
            return this;
        }

        public Builder addApproaches(String ... approaches) {
            this.directionsBuilder.addApproaches(approaches);
            return this;
        }

        public Builder addWaypointIndices(Integer ... indices) {
            this.directionsBuilder.addWaypointIndices(indices);
            return this;
        }

        public Builder addWaypointNames(String ... waypointNames) {
            this.directionsBuilder.addWaypointNames(waypointNames);
            return this;
        }

        public Builder addWaypointTargets(Point ... waypointTargets) {
            this.directionsBuilder.addWaypointTargets(waypointTargets);
            return this;
        }

        public Builder interceptor(Interceptor interceptor) {
            this.directionsBuilder.interceptor(interceptor);
            return this;
        }

        public Builder eventListener(EventListener eventListener) {
            this.directionsBuilder.eventListener(eventListener);
            return this;
        }

        public Builder enableRefresh(boolean enableRefresh) {
            this.directionsBuilder.enableRefresh(Boolean.valueOf(enableRefresh));
            return this;
        }

        public Builder continueStraight(boolean continueStraight) {
            this.directionsBuilder.continueStraight(Boolean.valueOf(continueStraight));
            return this;
        }

        public Builder walkingOptions(NavigationWalkingOptions navigationWalkingOptions) {
            this.directionsBuilder.walkingOptions(navigationWalkingOptions.getWalkingOptions());
            return this;
        }

        public Builder routeOptions(RouteOptions options) {
            String radiuses;
            WalkingOptions walkingOptions;
            String waypointTargets;
            String waypointIndices;
            if (!TextUtils.isEmpty((CharSequence)options.baseUrl())) {
                this.directionsBuilder.baseUrl(options.baseUrl());
            }
            if (!TextUtils.isEmpty((CharSequence)options.language())) {
                this.directionsBuilder.language(new Locale(options.language()));
            }
            if (options.alternatives() != null) {
                this.directionsBuilder.alternatives(options.alternatives());
            }
            if (!TextUtils.isEmpty((CharSequence)options.profile())) {
                this.directionsBuilder.profile(options.profile());
            }
            if (!TextUtils.isEmpty((CharSequence)options.voiceUnits())) {
                this.directionsBuilder.voiceUnits(options.voiceUnits());
            }
            if (!TextUtils.isEmpty((CharSequence)options.user())) {
                this.directionsBuilder.user(options.user());
            }
            if (!TextUtils.isEmpty((CharSequence)options.accessToken())) {
                this.directionsBuilder.accessToken(options.accessToken());
            }
            if (!TextUtils.isEmpty((CharSequence)options.annotations())) {
                this.directionsBuilder.annotations(new String[]{options.annotations()});
            }
            if (!TextUtils.isEmpty((CharSequence)options.approaches())) {
                String[] approaches = options.approaches().split(SEMICOLON);
                this.directionsBuilder.addApproaches(approaches);
            }
            if (!TextUtils.isEmpty((CharSequence)(waypointIndices = options.waypointIndices()))) {
                Integer[] splitWaypointIndices = this.parseWaypointIndices(waypointIndices);
                this.directionsBuilder.addWaypointIndices(splitWaypointIndices);
            }
            if (!TextUtils.isEmpty((CharSequence)options.waypointNames())) {
                String[] waypointNames = options.waypointNames().split(SEMICOLON);
                this.directionsBuilder.addWaypointNames(waypointNames);
            }
            if (!TextUtils.isEmpty((CharSequence)(waypointTargets = options.waypointTargets()))) {
                Point[] splitWaypointTargets = this.parseWaypointTargets(waypointTargets);
                this.directionsBuilder.addWaypointTargets(splitWaypointTargets);
            }
            if ((walkingOptions = options.walkingOptions()) != null) {
                this.directionsBuilder.walkingOptions(walkingOptions);
            }
            if (options.continueStraight() != null) {
                this.directionsBuilder.continueStraight(options.continueStraight());
            }
            if (!TextUtils.isEmpty((CharSequence)options.exclude())) {
                this.directionsBuilder.exclude(options.exclude());
            }
            if (!TextUtils.isEmpty((CharSequence)(radiuses = options.radiuses()))) {
                double[] splitRadiuses = this.parseRadiuses(radiuses);
                this.directionsBuilder.radiuses(splitRadiuses);
            }
            return this;
        }

        public NavigationRoute build() {
            this.assembleWaypoints();
            this.directionsBuilder.steps(Boolean.valueOf(true)).geometries("polyline6").overview("full").voiceInstructions(Boolean.valueOf(true)).bannerInstructions(Boolean.valueOf(true)).roundaboutExits(Boolean.valueOf(true)).eventListener((EventListener)this.eventListener).enableRefresh(Boolean.valueOf(true));
            return new NavigationRoute(this.directionsBuilder.build());
        }

        @NonNull
        private Integer[] parseWaypointIndices(String waypointIndices) {
            String[] splitWaypointIndices = waypointIndices.split(SEMICOLON);
            Integer[] indices = new Integer[splitWaypointIndices.length];
            int index = 0;
            for (String waypointIndex : splitWaypointIndices) {
                int parsedIndex = Integer.valueOf(waypointIndex);
                indices[index++] = parsedIndex;
            }
            return indices;
        }

        @NonNull
        private Point[] parseWaypointTargets(String waypointTargets) {
            String[] splitWaypointTargets = waypointTargets.split(SEMICOLON);
            Point[] waypoints = new Point[splitWaypointTargets.length];
            int index = 0;
            for (String waypointTarget : splitWaypointTargets) {
                String[] point = waypointTarget.split(COMMA);
                if (waypointTarget.isEmpty()) {
                    waypoints[index++] = null;
                    continue;
                }
                double longitude = Double.valueOf(point[0]);
                double latitude = Double.valueOf(point[0]);
                waypoints[index++] = Point.fromLngLat((double)longitude, (double)latitude);
            }
            return waypoints;
        }

        @NonNull
        private double[] parseRadiuses(String radiuses) {
            String[] splitRadiuses = radiuses.split(SEMICOLON);
            double[] radiusesArray = new double[splitRadiuses.length];
            int index = 0;
            for (String radiusIndex : splitRadiuses) {
                double parsedRadius = Double.valueOf(radiusIndex);
                radiusesArray[index++] = parsedRadius;
            }
            return radiusesArray;
        }

        private void assembleWaypoints() {
            if (this.origin != null) {
                this.directionsBuilder.origin(this.origin.getWaypoint());
                this.directionsBuilder.addBearing(this.origin.getBearingAngle(), this.origin.getTolerance());
            }
            for (NavigationRouteWaypoint waypoint : this.waypoints) {
                this.directionsBuilder.addWaypoint(waypoint.getWaypoint());
                this.directionsBuilder.addBearing(waypoint.getBearingAngle(), waypoint.getTolerance());
            }
            if (this.destination != null) {
                this.directionsBuilder.destination(this.destination.getWaypoint());
                this.directionsBuilder.addBearing(this.destination.getBearingAngle(), this.destination.getTolerance());
            }
        }
    }
}

