/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.support.annotation.Nullable;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.api.directions.v5.models.LegAnnotation;
import com.mapbox.api.directions.v5.models.LegStep;
import com.mapbox.api.directions.v5.models.MaxSpeed;
import com.mapbox.api.directions.v5.models.RouteLeg;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.utils.PolylineUtils;
import com.mapbox.services.android.navigation.v5.milestone.Milestone;
import com.mapbox.services.android.navigation.v5.routeprogress.CurrentLegAnnotation;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import java.util.ArrayList;
import java.util.List;

public class NavigationHelper {
    private static final int INDEX_ZERO = 0;
    private static final String EMPTY_STRING = "";

    private NavigationHelper() {
    }

    static String buildInstructionString(RouteProgress routeProgress, Milestone milestone) {
        if (milestone.getInstruction() != null) {
            return milestone.getInstruction().buildInstruction(routeProgress);
        }
        return EMPTY_STRING;
    }

    static double routeDistanceRemaining(double legDistanceRemaining, int legIndex, DirectionsRoute directionsRoute) {
        if (directionsRoute.legs().size() < 2) {
            return legDistanceRemaining;
        }
        for (int i = legIndex + 1; i < directionsRoute.legs().size(); ++i) {
            legDistanceRemaining += ((RouteLeg)directionsRoute.legs().get(i)).distance().doubleValue();
        }
        return legDistanceRemaining;
    }

    static List<Point> decodeStepPoints(DirectionsRoute directionsRoute, List<Point> currentPoints, int legIndex, int stepIndex) {
        boolean invalidStepIndex;
        List legs = directionsRoute.legs();
        if (NavigationHelper.hasInvalidLegs(legs)) {
            return currentPoints;
        }
        List steps = ((RouteLeg)legs.get(legIndex)).steps();
        if (NavigationHelper.hasInvalidSteps(steps)) {
            return currentPoints;
        }
        boolean bl = invalidStepIndex = stepIndex < 0 || stepIndex > steps.size() - 1;
        if (invalidStepIndex) {
            return currentPoints;
        }
        LegStep step = (LegStep)steps.get(stepIndex);
        if (step == null) {
            return currentPoints;
        }
        String stepGeometry = step.geometry();
        if (stepGeometry != null) {
            return PolylineUtils.decode((String)stepGeometry, (int)6);
        }
        return currentPoints;
    }

    @Nullable
    public static CurrentLegAnnotation createCurrentAnnotation(CurrentLegAnnotation currentLegAnnotation, RouteLeg leg, double legDistanceRemaining) {
        List congestionList;
        List maxspeedList;
        List speedList;
        LegAnnotation legAnnotation = leg.annotation();
        if (legAnnotation == null) {
            return null;
        }
        List distanceList = legAnnotation.distance();
        if (distanceList == null || distanceList.isEmpty()) {
            return null;
        }
        CurrentLegAnnotation.Builder annotationBuilder = CurrentLegAnnotation.builder();
        int annotationIndex = NavigationHelper.findAnnotationIndex(currentLegAnnotation, annotationBuilder, leg, legDistanceRemaining, distanceList);
        annotationBuilder.distance((Double)distanceList.get(annotationIndex));
        List durationList = legAnnotation.duration();
        if (durationList != null) {
            annotationBuilder.duration((Double)durationList.get(annotationIndex));
        }
        if ((speedList = legAnnotation.speed()) != null) {
            annotationBuilder.speed((Double)speedList.get(annotationIndex));
        }
        if ((maxspeedList = legAnnotation.maxspeed()) != null) {
            annotationBuilder.maxspeed((MaxSpeed)maxspeedList.get(annotationIndex));
        }
        if ((congestionList = legAnnotation.congestion()) != null) {
            annotationBuilder.congestion((String)congestionList.get(annotationIndex));
        }
        annotationBuilder.index(annotationIndex);
        return annotationBuilder.build();
    }

    private static int findAnnotationIndex(CurrentLegAnnotation currentLegAnnotation, CurrentLegAnnotation.Builder annotationBuilder, RouteLeg leg, double legDistanceRemaining, List<Double> distanceAnnotationList) {
        ArrayList<Double> legDistances = new ArrayList<Double>(distanceAnnotationList);
        Double totalLegDistance = leg.distance();
        double distanceTraveled = totalLegDistance - legDistanceRemaining;
        int distanceIndex = 0;
        double annotationDistancesTraveled = 0.0;
        if (currentLegAnnotation != null) {
            distanceIndex = currentLegAnnotation.index();
            annotationDistancesTraveled = currentLegAnnotation.distanceToAnnotation();
        }
        for (int i = distanceIndex; i < legDistances.size(); ++i) {
            Double distance = (Double)legDistances.get(i);
            if (!((annotationDistancesTraveled += distance.doubleValue()) > distanceTraveled)) continue;
            double distanceToAnnotation = annotationDistancesTraveled - distance;
            annotationBuilder.distanceToAnnotation(distanceToAnnotation);
            return i;
        }
        return 0;
    }

    private static boolean hasInvalidLegs(List<RouteLeg> legs) {
        return legs == null || legs.isEmpty();
    }

    private static boolean hasInvalidSteps(List<LegStep> steps) {
        return steps == null || steps.isEmpty();
    }
}

