/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.location.Location;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.gson.GeometryGeoJson;
import com.mapbox.navigator.BannerInstruction;
import com.mapbox.navigator.FixLocation;
import com.mapbox.navigator.NavigationStatus;
import com.mapbox.navigator.Navigator;
import com.mapbox.navigator.VoiceInstruction;
import com.mapbox.services.android.navigation.v5.navigation.DirectionsRouteType;
import com.mapbox.services.android.navigation.v5.navigation.RouteHandler;
import java.util.Date;

class MapboxNavigator {
    private static final int INDEX_FIRST_ROUTE = 0;
    private static final float GRID_SIZE = 0.0025f;
    private static final short BUFFER_DILATION = 1;
    private final Navigator navigator;
    private final RouteHandler routeHandler;

    MapboxNavigator(Navigator navigator) {
        this.navigator = navigator;
        this.routeHandler = new RouteHandler(this);
    }

    void updateRoute(DirectionsRoute route, DirectionsRouteType routeType) {
        this.routeHandler.updateRoute(route, routeType);
    }

    synchronized NavigationStatus setRoute(@NonNull String routeJson, int routeIndex, int legIndex) {
        return this.navigator.setRoute(routeJson, routeIndex, legIndex);
    }

    synchronized boolean updateAnnotations(@NonNull String legAnnotationJson, int routeIndex, int legIndex) {
        return this.navigator.updateAnnotations(legAnnotationJson, routeIndex, legIndex);
    }

    synchronized NavigationStatus retrieveStatus(Date date, long lagInMilliseconds) {
        if (lagInMilliseconds > 0L) {
            date.setTime(date.getTime() + lagInMilliseconds);
        }
        return this.navigator.getStatus(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateLocation(Location raw) {
        FixLocation fixedLocation = this.buildFixLocationFromLocation(raw);
        MapboxNavigator mapboxNavigator = this;
        synchronized (mapboxNavigator) {
            this.navigator.updateLocation(fixedLocation);
        }
    }

    synchronized NavigationStatus updateLegIndex(int index) {
        return this.navigator.changeRouteLeg(0, index);
    }

    synchronized String retrieveHistory() {
        return this.navigator.getHistory();
    }

    synchronized void toggleHistory(boolean isEnabled) {
        this.navigator.toggleHistory(isEnabled);
    }

    synchronized void addHistoryEvent(String eventType, String eventJsonProperties) {
        this.navigator.pushHistory(eventType, eventJsonProperties);
    }

    synchronized VoiceInstruction retrieveVoiceInstruction(int index) {
        return this.navigator.getVoiceInstruction(index);
    }

    synchronized BannerInstruction retrieveBannerInstruction(int index) {
        return this.navigator.getBannerInstruction(index);
    }

    @Nullable
    synchronized Geometry retrieveRouteGeometryWithBuffer() {
        String routeGeometryWithBuffer = this.navigator.getRouteBufferGeoJson(0.0025f, (short)1);
        if (routeGeometryWithBuffer == null) {
            return null;
        }
        return GeometryGeoJson.fromJson((String)routeGeometryWithBuffer);
    }

    private FixLocation buildFixLocationFromLocation(Location location) {
        Date time = new Date();
        Point rawPoint = Point.fromLngLat((double)location.getLongitude(), (double)location.getLatitude());
        Float speed = this.checkFor(Float.valueOf(location.getSpeed()));
        Float bearing = this.checkFor(Float.valueOf(location.getBearing()));
        Float altitude = this.checkFor(Float.valueOf((float)location.getAltitude()));
        Float horizontalAccuracy = this.checkFor(Float.valueOf(location.getAccuracy()));
        String provider = location.getProvider();
        return new FixLocation(rawPoint, time, speed, bearing, altitude, horizontalAccuracy, provider);
    }

    private Float checkFor(Float value) {
        if ((double)value.floatValue() == 0.0) {
            return null;
        }
        return value;
    }
}

