/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.NotificationCompat;
import android.support.v4.content.ContextCompat;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.format.DateFormat;
import android.widget.RemoteViews;
import com.mapbox.api.directions.v5.models.LegStep;
import com.mapbox.api.directions.v5.models.RouteOptions;
import com.mapbox.api.directions.v5.models.StepManeuver;
import com.mapbox.navigator.BannerInstruction;
import com.mapbox.services.android.navigation.R;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigation;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigationOptions;
import com.mapbox.services.android.navigation.v5.navigation.notification.NavigationNotification;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import com.mapbox.services.android.navigation.v5.utils.DistanceFormatter;
import com.mapbox.services.android.navigation.v5.utils.LocaleUtils;
import com.mapbox.services.android.navigation.v5.utils.time.TimeFormatter;
import java.util.Calendar;

class MapboxNavigationNotification
implements NavigationNotification {
    private static final String END_NAVIGATION_ACTION = "com.mapbox.intent.action.END_NAVIGATION";
    private static final String SET_BACKGROUND_COLOR = "setBackgroundColor";
    private NotificationManager notificationManager;
    private Notification notification;
    private RemoteViews collapsedNotificationRemoteViews;
    private RemoteViews expandedNotificationRemoteViews;
    private MapboxNavigation mapboxNavigation;
    private SpannableString currentDistanceText;
    private DistanceFormatter distanceFormatter;
    private String instructionText;
    private int currentManeuverId;
    private boolean isTwentyFourHourFormat;
    private String etaFormat;
    private final Context applicationContext;
    private PendingIntent pendingOpenIntent;
    private PendingIntent pendingCloseIntent;
    private BroadcastReceiver endNavigationBtnReceiver = new BroadcastReceiver(){

        public void onReceive(Context applicationContext, Intent intent) {
            MapboxNavigationNotification.this.onEndNavigationBtnClick();
        }
    };

    MapboxNavigationNotification(Context applicationContext, MapboxNavigation mapboxNavigation) {
        this.applicationContext = applicationContext;
        this.initialize(applicationContext, mapboxNavigation);
    }

    MapboxNavigationNotification(Context applicationContext, MapboxNavigation mapboxNavigation, Notification notification) {
        this.applicationContext = applicationContext;
        this.notification = notification;
        this.initialize(applicationContext, mapboxNavigation);
    }

    @Override
    public Notification getNotification() {
        return this.notification;
    }

    @Override
    public int getNotificationId() {
        return 5678;
    }

    @Override
    public void updateNotification(RouteProgress routeProgress) {
        this.updateNotificationViews(routeProgress);
        this.rebuildNotification();
    }

    @Override
    public void onNavigationStopped(Context applicationContext) {
        this.unregisterReceiver(applicationContext);
    }

    String generateArrivalTime(RouteProgress routeProgress, Calendar time) {
        MapboxNavigationOptions options = this.mapboxNavigation.options();
        double legDurationRemaining = routeProgress.currentLegProgress().durationRemaining();
        int timeFormatType = options.timeFormatType();
        String arrivalTime = TimeFormatter.formatTime(time, legDurationRemaining, timeFormatType, this.isTwentyFourHourFormat);
        String formattedArrivalTime = String.format(this.etaFormat, arrivalTime);
        return formattedArrivalTime;
    }

    void updateNotificationViews(RouteProgress routeProgress) {
        this.buildRemoteViews();
        this.updateInstructionText(routeProgress.bannerInstruction());
        this.updateDistanceText(routeProgress);
        Calendar time = Calendar.getInstance();
        String formattedTime = this.generateArrivalTime(routeProgress, time);
        this.updateViewsWithArrival(formattedTime);
        LegStep step = routeProgress.currentLegProgress().upComingStep() != null ? routeProgress.currentLegProgress().upComingStep() : routeProgress.currentLegProgress().currentStep();
        this.updateManeuverImage(step);
    }

    String retrieveInstructionText() {
        return this.instructionText;
    }

    int retrieveCurrentManeuverId() {
        return this.currentManeuverId;
    }

    private void initialize(Context applicationContext, MapboxNavigation mapboxNavigation) {
        this.mapboxNavigation = mapboxNavigation;
        this.etaFormat = applicationContext.getString(R.string.eta_format);
        this.initializeDistanceFormatter(applicationContext, mapboxNavigation);
        this.notificationManager = (NotificationManager)applicationContext.getSystemService("notification");
        this.isTwentyFourHourFormat = DateFormat.is24HourFormat((Context)applicationContext);
        this.pendingOpenIntent = this.createPendingOpenIntent(applicationContext);
        this.pendingCloseIntent = this.createPendingCloseIntent(applicationContext);
        this.registerReceiver(applicationContext);
        this.createNotificationChannel(applicationContext);
        if (this.notification == null) {
            this.notification = this.buildNotification(applicationContext);
        }
    }

    private void initializeDistanceFormatter(Context applicationContext, MapboxNavigation mapboxNavigation) {
        RouteOptions routeOptions = mapboxNavigation.getRoute().routeOptions();
        LocaleUtils localeUtils = new LocaleUtils();
        String language = localeUtils.inferDeviceLanguage(applicationContext);
        String unitType = localeUtils.getUnitTypeForDeviceLocale(applicationContext);
        if (routeOptions != null) {
            language = routeOptions.language();
            unitType = routeOptions.voiceUnits();
        }
        MapboxNavigationOptions mapboxNavigationOptions = mapboxNavigation.options();
        int roundingIncrement = mapboxNavigationOptions.roundingIncrement();
        this.distanceFormatter = new DistanceFormatter(applicationContext, language, unitType, roundingIncrement);
    }

    private void createNotificationChannel(Context applicationContext) {
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel notificationChannel = new NotificationChannel("NAVIGATION_NOTIFICATION_CHANNEL", (CharSequence)applicationContext.getString(R.string.channel_name), 2);
            this.notificationManager.createNotificationChannel(notificationChannel);
        }
    }

    private Notification buildNotification(Context applicationContext) {
        String channelId = "NAVIGATION_NOTIFICATION_CHANNEL";
        NotificationCompat.Builder builder = new NotificationCompat.Builder(applicationContext, channelId).setCategory("service").setPriority(2).setSmallIcon(R.drawable.ic_navigation).setCustomContentView(this.collapsedNotificationRemoteViews).setCustomBigContentView(this.expandedNotificationRemoteViews).setOngoing(true);
        if (this.pendingOpenIntent != null) {
            builder.setContentIntent(this.pendingOpenIntent);
        }
        return builder.build();
    }

    private void buildRemoteViews() {
        int colorResId = this.mapboxNavigation.options().defaultNotificationColorId();
        int backgroundColor = ContextCompat.getColor((Context)this.applicationContext, (int)colorResId);
        int collapsedLayout = R.layout.collapsed_navigation_notification_layout;
        int collapsedLayoutId = R.id.navigationCollapsedNotificationLayout;
        this.collapsedNotificationRemoteViews = new RemoteViews(this.applicationContext.getPackageName(), collapsedLayout);
        this.collapsedNotificationRemoteViews.setInt(collapsedLayoutId, SET_BACKGROUND_COLOR, backgroundColor);
        int expandedLayout = R.layout.expanded_navigation_notification_layout;
        int expandedLayoutId = R.id.navigationExpandedNotificationLayout;
        this.expandedNotificationRemoteViews = new RemoteViews(this.applicationContext.getPackageName(), expandedLayout);
        this.expandedNotificationRemoteViews.setOnClickPendingIntent(R.id.endNavigationBtn, this.pendingCloseIntent);
        this.expandedNotificationRemoteViews.setInt(expandedLayoutId, SET_BACKGROUND_COLOR, backgroundColor);
    }

    @Nullable
    private PendingIntent createPendingOpenIntent(Context applicationContext) {
        PackageManager pm = applicationContext.getPackageManager();
        Intent intent = pm.getLaunchIntentForPackage(applicationContext.getPackageName());
        if (intent == null) {
            return null;
        }
        intent.setPackage(null);
        return PendingIntent.getActivity((Context)applicationContext, (int)0, (Intent)intent, (int)0);
    }

    private PendingIntent createPendingCloseIntent(Context applicationContext) {
        Intent endNavigationBtn = new Intent(END_NAVIGATION_ACTION);
        return PendingIntent.getBroadcast((Context)applicationContext, (int)0, (Intent)endNavigationBtn, (int)0);
    }

    private void registerReceiver(Context applicationContext) {
        if (applicationContext != null) {
            applicationContext.registerReceiver(this.endNavigationBtnReceiver, new IntentFilter(END_NAVIGATION_ACTION));
        }
    }

    private void rebuildNotification() {
        this.notification = this.buildNotification(this.applicationContext);
        this.notificationManager.notify(5678, this.notification);
    }

    private void unregisterReceiver(Context applicationContext) {
        if (applicationContext != null) {
            applicationContext.unregisterReceiver(this.endNavigationBtnReceiver);
        }
        if (this.notificationManager != null) {
            this.notificationManager.cancel(5678);
        }
    }

    private void updateInstructionText(BannerInstruction bannerInstruction) {
        if (bannerInstruction != null && (this.instructionText == null || this.newInstructionText(bannerInstruction))) {
            this.instructionText = bannerInstruction.getPrimary().getText();
            this.updateViewsWithInstruction(this.instructionText);
        }
    }

    private void updateViewsWithInstruction(String text) {
        this.collapsedNotificationRemoteViews.setTextViewText(R.id.notificationInstructionText, (CharSequence)text);
        this.expandedNotificationRemoteViews.setTextViewText(R.id.notificationInstructionText, (CharSequence)text);
    }

    private boolean newInstructionText(BannerInstruction bannerInstruction) {
        return !this.instructionText.equals(bannerInstruction.getPrimary().getText());
    }

    private void updateDistanceText(RouteProgress routeProgress) {
        if (this.currentDistanceText == null || this.newDistanceText(routeProgress)) {
            this.currentDistanceText = this.distanceFormatter.formatDistance(routeProgress.currentLegProgress().currentStepProgress().distanceRemaining());
            this.collapsedNotificationRemoteViews.setTextViewText(R.id.notificationDistanceText, (CharSequence)this.currentDistanceText);
            this.expandedNotificationRemoteViews.setTextViewText(R.id.notificationDistanceText, (CharSequence)this.currentDistanceText);
        }
    }

    private boolean newDistanceText(RouteProgress routeProgress) {
        String formattedDistance = this.distanceFormatter.formatDistance(routeProgress.currentLegProgress().currentStepProgress().distanceRemaining()).toString();
        String currentDistance = this.currentDistanceText.toString();
        return this.currentDistanceText != null && currentDistance != null && !currentDistance.equals(formattedDistance);
    }

    private void updateViewsWithArrival(String time) {
        this.collapsedNotificationRemoteViews.setTextViewText(R.id.notificationArrivalText, (CharSequence)time);
        this.expandedNotificationRemoteViews.setTextViewText(R.id.notificationArrivalText, (CharSequence)time);
    }

    private void updateManeuverImage(@NonNull LegStep step) {
        int maneuverResource = this.getManeuverResource(step);
        if (this.currentManeuverId != maneuverResource) {
            this.currentManeuverId = maneuverResource;
            this.collapsedNotificationRemoteViews.setImageViewResource(R.id.maneuverImage, maneuverResource);
            this.expandedNotificationRemoteViews.setImageViewResource(R.id.maneuverImage, maneuverResource);
        }
    }

    private int getManeuverResource(@NonNull LegStep step) {
        StepManeuver maneuver = step.maneuver();
        String maneuverType = maneuver.type();
        String maneuverModifier = maneuver.modifier();
        if (!TextUtils.isEmpty((CharSequence)maneuverModifier)) {
            String drivingSide = step.drivingSide();
            if (this.isLeftDrivingSideAndRoundaboutOrRotaryOrUturn(maneuverType, maneuverModifier, drivingSide)) {
                return this.obtainManeuverResourceFrom(maneuverType + maneuverModifier + drivingSide);
            }
            return this.obtainManeuverResourceFrom(maneuverType + maneuverModifier);
        }
        return this.obtainManeuverResourceFrom(maneuverType);
    }

    private int obtainManeuverResourceFrom(String maneuver) {
        switch (maneuver) {
            case "turnuturn": 
            case "continueuturn": {
                return R.drawable.ic_maneuver_turn_180;
            }
            case "turnuturnleft": 
            case "continueuturnleft": {
                return R.drawable.ic_maneuver_turn_180_left_driving_side;
            }
            case "arriveleft": {
                return R.drawable.ic_maneuver_arrive_left;
            }
            case "arriveright": {
                return R.drawable.ic_maneuver_arrive_right;
            }
            case "arrive": {
                return R.drawable.ic_maneuver_arrive;
            }
            case "departleft": {
                return R.drawable.ic_maneuver_depart_left;
            }
            case "departright": {
                return R.drawable.ic_maneuver_depart_right;
            }
            case "depart": {
                return R.drawable.ic_maneuver_depart;
            }
            case "turnsharp right": 
            case "on rampsharp right": 
            case "notificationsharp right": {
                return R.drawable.ic_maneuver_turn_75;
            }
            case "turnright": 
            case "on rampright": 
            case "roundabout turnright": 
            case "notificationright": {
                return R.drawable.ic_maneuver_turn_45;
            }
            case "turnslight right": 
            case "on rampslight right": 
            case "notificationslight right": {
                return R.drawable.ic_maneuver_turn_30;
            }
            case "turnsharp left": 
            case "on rampsharp left": 
            case "notificationsharp left": {
                return R.drawable.ic_maneuver_turn_75_left;
            }
            case "turnleft": 
            case "on rampleft": 
            case "notificationleft": 
            case "roundabout turnleft": {
                return R.drawable.ic_maneuver_turn_45_left;
            }
            case "turnslight left": 
            case "on rampslight left": 
            case "notificationslight left": {
                return R.drawable.ic_maneuver_turn_30_left;
            }
            case "mergeleft": 
            case "mergeslight left": {
                return R.drawable.ic_maneuver_merge_left;
            }
            case "mergeright": 
            case "mergeslight right": {
                return R.drawable.ic_maneuver_merge_right;
            }
            case "off rampleft": {
                return R.drawable.ic_maneuver_off_ramp_left;
            }
            case "off rampslight left": {
                return R.drawable.ic_maneuver_off_ramp_slight_left;
            }
            case "off rampright": {
                return R.drawable.ic_maneuver_off_ramp_right;
            }
            case "off rampslight right": {
                return R.drawable.ic_maneuver_off_ramp_slight_right;
            }
            case "forkleft": {
                return R.drawable.ic_maneuver_fork_left;
            }
            case "forkslight left": {
                return R.drawable.ic_maneuver_fork_slight_left;
            }
            case "forkright": {
                return R.drawable.ic_maneuver_fork_right;
            }
            case "forkslight right": {
                return R.drawable.ic_maneuver_fork_slight_right;
            }
            case "forkstraight": {
                return R.drawable.ic_maneuver_fork_straight;
            }
            case "fork": {
                return R.drawable.ic_maneuver_fork;
            }
            case "end of roadleft": {
                return R.drawable.ic_maneuver_end_of_road_left;
            }
            case "end of roadright": {
                return R.drawable.ic_maneuver_end_of_road_right;
            }
            case "roundaboutleft": 
            case "rotaryleft": {
                return R.drawable.ic_maneuver_roundabout_left;
            }
            case "roundaboutsharp left": 
            case "rotarysharp left": {
                return R.drawable.ic_maneuver_roundabout_sharp_left;
            }
            case "roundaboutslight left": 
            case "rotaryslight left": {
                return R.drawable.ic_maneuver_roundabout_slight_left;
            }
            case "roundaboutright": 
            case "rotaryright": {
                return R.drawable.ic_maneuver_roundabout_right;
            }
            case "roundaboutsharp right": 
            case "rotarysharp right": {
                return R.drawable.ic_maneuver_roundabout_sharp_right;
            }
            case "roundaboutslight right": 
            case "rotaryslight right": {
                return R.drawable.ic_maneuver_roundabout_slight_right;
            }
            case "roundaboutstraight": 
            case "rotarystraight": {
                return R.drawable.ic_maneuver_roundabout_straight;
            }
            case "roundabout": 
            case "rotary": {
                return R.drawable.ic_maneuver_roundabout;
            }
            case "roundaboutleftleft": 
            case "rotaryleftleft": {
                return R.drawable.ic_maneuver_roundabout_left_left_driving_side;
            }
            case "roundaboutsharp leftleft": 
            case "rotarysharp leftleft": {
                return R.drawable.ic_maneuver_roundabout_sharp_left_left_driving_side;
            }
            case "roundaboutslight leftleft": 
            case "rotaryslight leftleft": {
                return R.drawable.ic_maneuver_roundabout_slight_left_left_driving_side;
            }
            case "roundaboutrightleft": 
            case "rotaryrightleft": {
                return R.drawable.ic_maneuver_roundabout_right_left_driving_side;
            }
            case "roundaboutsharp rightleft": 
            case "rotarysharp rightleft": {
                return R.drawable.ic_maneuver_roundabout_sharp_right_left_driving_side;
            }
            case "roundaboutslight rightleft": 
            case "rotaryslight rightleft": {
                return R.drawable.ic_maneuver_roundabout_slight_right_left_driving_side;
            }
            case "roundaboutstraightleft": 
            case "rotarystraightleft": {
                return R.drawable.ic_maneuver_roundabout_straight_left_driving_side;
            }
        }
        return R.drawable.ic_maneuver_turn_0;
    }

    private boolean isLeftDrivingSideAndRoundaboutOrRotaryOrUturn(String maneuverType, String maneuverModifier, String drivingSide) {
        return "left".equals(drivingSide) && ("roundabout".equals(maneuverType) || "rotary".equals(maneuverType) || "uturn".equals(maneuverModifier));
    }

    private void onEndNavigationBtnClick() {
        if (this.mapboxNavigation != null) {
            this.mapboxNavigation.stopNavigation();
        }
    }
}

