/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.support.annotation.NonNull;
import com.mapbox.services.android.navigation.v5.navigation.DownloadUpdateListener;
import com.mapbox.services.android.navigation.v5.navigation.OfflineError;
import com.mapbox.services.android.navigation.v5.navigation.OfflineNavigator;
import com.mapbox.services.android.navigation.v5.navigation.OfflineTiles;
import com.mapbox.services.android.navigation.v5.navigation.RouteTileDownloadListener;
import com.mapbox.services.android.navigation.v5.navigation.TarFetchedCallback;
import com.mapbox.services.android.navigation.v5.navigation.TileUnpacker;
import com.mapbox.services.android.navigation.v5.utils.DownloadTask;

class RouteTileDownloader {
    private static final String FILE_EXTENSION_TAR = "tar";
    private final OfflineNavigator offlineNavigator;
    private final String tilePath;
    private final RouteTileDownloadListener listener;

    RouteTileDownloader(OfflineNavigator offlineNavigator, String tilePath, RouteTileDownloadListener listener) {
        this.offlineNavigator = offlineNavigator;
        this.tilePath = tilePath;
        this.listener = listener;
    }

    void startDownload(OfflineTiles offlineTiles) {
        String version = offlineTiles.version();
        TarFetchedCallback tarFetchedCallback = this.buildTarFetchedCallback(version);
        offlineTiles.fetchRouteTiles(tarFetchedCallback);
    }

    void onError(OfflineError error) {
        if (this.listener != null) {
            this.listener.onError(error);
        }
    }

    @NonNull
    private TarFetchedCallback buildTarFetchedCallback(String version) {
        DownloadTask downloadTask = this.buildDownloadTask(this.tilePath, version);
        return new TarFetchedCallback(this, downloadTask);
    }

    @NonNull
    private DownloadTask buildDownloadTask(String tilePath, String tileVersion) {
        TileUnpacker tileUnpacker = new TileUnpacker(this.offlineNavigator);
        DownloadUpdateListener downloadListener = new DownloadUpdateListener(this, tileUnpacker, tilePath, tileVersion, this.listener);
        return new DownloadTask(tilePath, tileVersion, FILE_EXTENSION_TAR, downloadListener);
    }
}

