/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.services.android.navigation.v5.navigation.DirectionsRouteType;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigation;
import com.mapbox.services.android.navigation.v5.navigation.RefreshCallback;
import com.mapbox.services.android.navigation.v5.navigation.RefreshError;
import com.mapbox.services.android.navigation.v5.navigation.RouteRefresher;
import java.util.Date;
import timber.log.Timber;

class RouteRefresherCallback
implements RefreshCallback {
    private final MapboxNavigation mapboxNavigation;
    private final RouteRefresher routeRefresher;

    RouteRefresherCallback(MapboxNavigation mapboxNavigation, RouteRefresher routeRefresher) {
        this.mapboxNavigation = mapboxNavigation;
        this.routeRefresher = routeRefresher;
    }

    @Override
    public void onRefresh(DirectionsRoute directionsRoute) {
        this.mapboxNavigation.startNavigation(directionsRoute, DirectionsRouteType.FRESH_ROUTE);
        this.routeRefresher.updateLastRefresh(new Date());
        this.routeRefresher.updateIsChecking(false);
    }

    @Override
    public void onError(RefreshError error) {
        Timber.w((String)error.getMessage(), (Object[])new Object[0]);
        this.routeRefresher.updateIsChecking(false);
    }
}

