/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.support.annotation.NonNull;
import com.mapbox.services.android.navigation.v5.navigation.OfflineError;
import com.mapbox.services.android.navigation.v5.navigation.RouteTileDownloadListener;
import com.mapbox.services.android.navigation.v5.navigation.RouteTileDownloader;
import com.mapbox.services.android.navigation.v5.navigation.TileUnpacker;
import com.mapbox.services.android.navigation.v5.navigation.UnpackProgressUpdateListener;
import com.mapbox.services.android.navigation.v5.utils.DownloadTask;
import java.io.File;

class DownloadUpdateListener
implements DownloadTask.DownloadListener {
    private static final String DOWNLOAD_ERROR_MESSAGE = "Error occurred downloading tiles: null file found";
    private final RouteTileDownloader downloader;
    private final TileUnpacker tileUnpacker;
    private final RouteTileDownloadListener listener;
    private final String destinationPath;

    DownloadUpdateListener(RouteTileDownloader downloader, TileUnpacker tileUnpacker, String tilePath, String tileVersion, RouteTileDownloadListener listener) {
        this.downloader = downloader;
        this.listener = listener;
        this.tileUnpacker = tileUnpacker;
        this.destinationPath = this.buildDestinationPath(tilePath, tileVersion);
    }

    @Override
    public void onFinishedDownloading(@NonNull File file) {
        this.tileUnpacker.unpack(file, this.destinationPath, new UnpackProgressUpdateListener(this.listener));
    }

    @Override
    public void onErrorDownloading() {
        OfflineError error = new OfflineError(DOWNLOAD_ERROR_MESSAGE);
        this.downloader.onError(error);
    }

    private String buildDestinationPath(String tilePath, String tileVersion) {
        File destination = new File(tilePath, tileVersion);
        if (!destination.exists()) {
            destination.mkdirs();
        }
        return destination.getAbsolutePath();
    }
}

