/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.location.replay;

import android.location.Location;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mapbox.services.android.navigation.v5.location.replay.GpxParser;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

class ParseGpxTask
extends AsyncTask<InputStream, Void, List<Location>> {
    private static final int FIRST_INPUT_STREAM = 0;
    private Listener listener;
    private GpxParser parser;

    ParseGpxTask(GpxParser parser, Listener listener) {
        this.parser = parser;
        this.listener = listener;
    }

    protected List<Location> doInBackground(InputStream ... inputStreams) {
        InputStream inputStream = inputStreams[0];
        try {
            return this.parseGpxStream(inputStream);
        }
        catch (IOException exception) {
            this.listener.onParseError(exception);
            return null;
        }
    }

    protected void onPostExecute(List<Location> locationList) {
        if (locationList != null && !locationList.isEmpty()) {
            this.listener.onParseComplete(locationList);
        } else {
            this.listener.onParseError(new RuntimeException("An error occurred parsing the GPX Xml."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private List<Location> parseGpxStream(InputStream inputStream) throws IOException {
        try {
            List<Location> list = this.parser.parseGpx(inputStream);
            return list;
        }
        catch (IOException | ParseException | ParserConfigurationException | SAXException exception) {
            exception.printStackTrace();
            this.listener.onParseError(exception);
            List<Location> list = null;
            return list;
        }
        finally {
            inputStream.close();
        }
    }

    public static interface Listener {
        public void onParseComplete(@NonNull List<Location> var1);

        public void onParseError(Exception var1);
    }
}

