/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.utils;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mapbox.api.directions.v5.models.BannerInstructions;
import com.mapbox.api.directions.v5.models.LegStep;
import com.mapbox.api.directions.v5.models.RouteLeg;
import com.mapbox.api.directions.v5.models.RouteOptions;
import com.mapbox.core.utils.TextUtils;
import com.mapbox.geojson.Point;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgressState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class RouteUtils {
    private static final int FIRST_INSTRUCTION = 0;
    private static final int ORIGIN_WAYPOINT_NAME_THRESHOLD = 1;
    private static final int ORIGIN_WAYPOINT_NAME = 0;
    private static final int FIRST_POSITION = 0;
    private static final int SECOND_POSITION = 1;
    private static final String SEMICOLON = ";";

    public boolean isArrivalEvent(@NonNull RouteProgress routeProgress) {
        RouteProgressState currentState = routeProgress.currentState();
        return currentState != null && currentState == RouteProgressState.ROUTE_ARRIVED;
    }

    public boolean isLastLeg(RouteProgress routeProgress) {
        List legs = routeProgress.directionsRoute().legs();
        RouteLeg currentLeg = routeProgress.currentLeg();
        return currentLeg.equals(legs.get(legs.size() - 1));
    }

    @Nullable
    public List<Point> calculateRemainingWaypoints(RouteProgress routeProgress) {
        int remainingWaypoints;
        if (routeProgress.directionsRoute().routeOptions() == null) {
            return null;
        }
        ArrayList coordinates = new ArrayList(routeProgress.directionsRoute().routeOptions().coordinates());
        int coordinatesSize = coordinates.size();
        if (coordinatesSize < (remainingWaypoints = routeProgress.remainingWaypoints())) {
            return null;
        }
        List<Point> remainingCoordinates = coordinates.subList(coordinatesSize - remainingWaypoints, coordinatesSize);
        return remainingCoordinates;
    }

    @Nullable
    public String[] calculateRemainingWaypointNames(RouteProgress routeProgress) {
        RouteOptions routeOptions = routeProgress.directionsRoute().routeOptions();
        if (routeOptions == null || TextUtils.isEmpty((CharSequence)routeOptions.waypointNames())) {
            return null;
        }
        String allWaypointNames = routeOptions.waypointNames();
        String[] names = allWaypointNames.split(SEMICOLON);
        int coordinatesSize = routeProgress.directionsRoute().routeOptions().coordinates().size();
        String[] remainingWaypointNames = Arrays.copyOfRange(names, coordinatesSize - routeProgress.remainingWaypoints(), coordinatesSize);
        String[] waypointNames = new String[remainingWaypointNames.length + 1];
        waypointNames[0] = names[0];
        System.arraycopy(remainingWaypointNames, 0, waypointNames, 1, remainingWaypointNames.length);
        return waypointNames;
    }

    @Nullable
    public BannerInstructions findCurrentBannerInstructions(LegStep currentStep, double stepDistanceRemaining) {
        if (this.isValidBannerInstructions(currentStep)) {
            List<BannerInstructions> instructions = this.sortBannerInstructions(currentStep.bannerInstructions());
            for (BannerInstructions instruction : instructions) {
                int distanceAlongGeometry = (int)instruction.distanceAlongGeometry();
                if (distanceAlongGeometry < (int)stepDistanceRemaining) continue;
                return instruction;
            }
            return instructions.get(0);
        }
        return null;
    }

    private boolean isValidBannerInstructions(LegStep currentStep) {
        return this.isValidStep(currentStep) && this.hasInstructions(currentStep.bannerInstructions());
    }

    private List<BannerInstructions> sortBannerInstructions(List<BannerInstructions> instructions) {
        ArrayList<BannerInstructions> sortedInstructions = new ArrayList<BannerInstructions>(instructions);
        Collections.sort(sortedInstructions, new Comparator<BannerInstructions>(){

            @Override
            public int compare(BannerInstructions instructions, BannerInstructions nextInstructions) {
                return Double.compare(instructions.distanceAlongGeometry(), nextInstructions.distanceAlongGeometry());
            }
        });
        return sortedInstructions;
    }

    private boolean isValidStep(LegStep step) {
        return step != null;
    }

    private <T> boolean hasInstructions(List<T> instructions) {
        return instructions != null && !instructions.isEmpty();
    }
}

