/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.utils;

import android.content.Context;
import android.location.Location;
import android.support.annotation.NonNull;
import android.text.SpannableString;
import android.text.style.RelativeSizeSpan;
import android.text.style.StyleSpan;
import com.mapbox.geojson.Point;
import com.mapbox.services.android.navigation.R;
import com.mapbox.services.android.navigation.v5.navigation.NavigationConstants;
import com.mapbox.services.android.navigation.v5.routeprogress.MetricsRouteProgress;
import com.mapbox.services.android.navigation.v5.utils.LocaleUtils;
import com.mapbox.turf.TurfConversion;
import com.mapbox.turf.TurfMeasurement;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class DistanceFormatter {
    private static final int LARGE_UNIT_THRESHOLD = 10;
    private static final int SMALL_UNIT_THRESHOLD = 401;
    @NavigationConstants.RoundingIncrement
    private final int roundingIncrement;
    private final Map<String, String> unitStrings = new HashMap<String, String>();
    private final NumberFormat numberFormat;
    private final String largeUnit;
    private final String smallUnit;
    private final LocaleUtils localeUtils;
    private final String language;
    private final String unitType;

    public DistanceFormatter(Context context, @NonNull String language, @NonNull String unitType, @NavigationConstants.RoundingIncrement int roundingIncrement) {
        this.roundingIncrement = roundingIncrement;
        this.localeUtils = new LocaleUtils();
        this.unitStrings.put("kilometers", context.getString(R.string.kilometers));
        this.unitStrings.put("meters", context.getString(R.string.meters));
        this.unitStrings.put("miles", context.getString(R.string.miles));
        this.unitStrings.put("feet", context.getString(R.string.feet));
        Locale locale = language == null ? this.localeUtils.inferDeviceLocale(context) : new Locale(language);
        this.language = locale.getLanguage();
        this.numberFormat = NumberFormat.getNumberInstance(locale);
        if (!"imperial".equals(unitType) && !"metric".equals(unitType)) {
            unitType = this.localeUtils.getUnitTypeForDeviceLocale(context);
        }
        this.unitType = unitType;
        this.largeUnit = "imperial".equals(unitType) ? "miles" : "kilometers";
        this.smallUnit = "imperial".equals(unitType) ? "feet" : "meters";
    }

    public SpannableString formatDistance(double distance) {
        double distanceSmallUnit = TurfConversion.convertLength((double)distance, (String)"meters", (String)this.smallUnit);
        double distanceLargeUnit = TurfConversion.convertLength((double)distance, (String)"meters", (String)this.largeUnit);
        if (distanceLargeUnit > 10.0) {
            return this.getDistanceString(this.roundToDecimalPlace(distanceLargeUnit, 0), this.largeUnit);
        }
        if (distanceSmallUnit < 401.0) {
            return this.getDistanceString(this.roundToClosestIncrement(distanceSmallUnit), this.smallUnit);
        }
        return this.getDistanceString(this.roundToDecimalPlace(distanceLargeUnit, 1), this.largeUnit);
    }

    public boolean shouldUpdate(@NonNull String language, @NonNull String unitType, int roundingIncrement) {
        return !this.language.equals(language) || !this.unitType.equals(unitType) || this.roundingIncrement != roundingIncrement;
    }

    private String roundToClosestIncrement(double distance) {
        int roundedNumber = (int)Math.round(distance) / this.roundingIncrement * this.roundingIncrement;
        return String.valueOf(roundedNumber < this.roundingIncrement ? this.roundingIncrement : roundedNumber);
    }

    private String roundToDecimalPlace(double distance, int decimalPlace) {
        this.numberFormat.setMaximumFractionDigits(decimalPlace);
        return this.numberFormat.format(distance);
    }

    private SpannableString getDistanceString(String distance, String unit) {
        SpannableString spannableString = new SpannableString((CharSequence)String.format("%s %s", distance, this.unitStrings.get(unit)));
        spannableString.setSpan((Object)new StyleSpan(1), 0, distance.length(), 33);
        spannableString.setSpan((Object)new RelativeSizeSpan(0.65f), distance.length() + 1, spannableString.length(), 33);
        return spannableString;
    }

    public static int calculateAbsoluteDistance(Location currentLocation, MetricsRouteProgress metricProgress) {
        Point currentPoint = Point.fromLngLat((double)currentLocation.getLongitude(), (double)currentLocation.getLatitude());
        Point finalPoint = metricProgress.getDirectionsRouteDestination();
        return (int)TurfMeasurement.distance((Point)currentPoint, (Point)finalPoint, (String)"meters");
    }
}

