/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigation;
import com.mapbox.services.android.navigation.v5.navigation.RouteRefresh;
import com.mapbox.services.android.navigation.v5.navigation.RouteRefresherCallback;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import java.util.Date;

class RouteRefresher {
    private final MapboxNavigation mapboxNavigation;
    private final RouteRefresh routeRefresh;
    private final long refreshIntervalInMilliseconds;
    private Date lastRefreshedDate;
    private boolean isChecking;
    private boolean isRefreshRouteEnabled;

    RouteRefresher(MapboxNavigation mapboxNavigation, RouteRefresh routeRefresh) {
        this.mapboxNavigation = mapboxNavigation;
        this.routeRefresh = routeRefresh;
        this.refreshIntervalInMilliseconds = mapboxNavigation.options().refreshIntervalInMilliseconds();
        this.lastRefreshedDate = new Date();
        this.isRefreshRouteEnabled = mapboxNavigation.options().enableRefreshRoute();
    }

    boolean check(Date currentDate) {
        if (this.isChecking || !this.isRefreshRouteEnabled) {
            return false;
        }
        long millisSinceLastRefresh = currentDate.getTime() - this.lastRefreshedDate.getTime();
        return millisSinceLastRefresh > this.refreshIntervalInMilliseconds;
    }

    void refresh(RouteProgress routeProgress) {
        this.updateIsChecking(true);
        this.routeRefresh.refresh(routeProgress, new RouteRefresherCallback(this.mapboxNavigation, this));
    }

    void updateLastRefresh(Date date) {
        this.lastRefreshedDate = date;
    }

    void updateIsChecking(boolean isChecking) {
        this.isChecking = isChecking;
    }
}

