/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.support.annotation.NonNull;
import com.mapbox.api.routetiles.v1.versions.MapboxRouteTileVersions;
import com.mapbox.api.routetiles.v1.versions.models.RouteTileVersionsResponse;
import com.mapbox.services.android.navigation.v5.navigation.OfflineError;
import com.mapbox.services.android.navigation.v5.navigation.OnTileVersionsFoundCallback;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

class OfflineTileVersions {
    OfflineTileVersions() {
    }

    void fetchRouteTileVersions(String accessToken, final OnTileVersionsFoundCallback callback) {
        MapboxRouteTileVersions mapboxRouteTileVersions = this.buildTileVersionsWith(accessToken);
        mapboxRouteTileVersions.enqueueCall((Callback)new Callback<RouteTileVersionsResponse>(){

            public void onResponse(@NonNull Call<RouteTileVersionsResponse> call, @NonNull Response<RouteTileVersionsResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    callback.onVersionsFound(((RouteTileVersionsResponse)response.body()).availableVersions());
                } else {
                    callback.onError(new OfflineError("Tile version response was unsuccessful"));
                }
            }

            public void onFailure(@NonNull Call<RouteTileVersionsResponse> call, @NonNull Throwable throwable) {
                OfflineError error = new OfflineError(throwable.getMessage());
                callback.onError(error);
            }
        });
    }

    private MapboxRouteTileVersions buildTileVersionsWith(String accessToken) {
        return MapboxRouteTileVersions.builder().accessToken(accessToken).build();
    }
}

