/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import com.mapbox.services.android.navigation.v5.location.MetricsLocation;
import com.mapbox.services.android.navigation.v5.navigation.DepartEventHandler;
import com.mapbox.services.android.navigation.v5.navigation.metrics.SessionState;
import com.mapbox.services.android.navigation.v5.routeprogress.MetricsRouteProgress;
import java.util.Date;

class DepartEventFactory {
    private static final int INITIAL_LEG_INDEX = -1;
    private final DepartEventHandler departEventHandler;
    private int currentLegIndex = -1;

    DepartEventFactory(DepartEventHandler departEventHandler) {
        this.departEventHandler = departEventHandler;
    }

    SessionState send(SessionState sessionState, MetricsRouteProgress routeProgress, MetricsLocation location) {
        sessionState = this.checkResetForNewLeg(sessionState, routeProgress);
        this.currentLegIndex = routeProgress.getLegIndex();
        if (this.isValidDeparture(sessionState, routeProgress)) {
            return this.sendToHandler(sessionState, routeProgress, location);
        }
        return sessionState;
    }

    void reset() {
        this.currentLegIndex = -1;
    }

    private SessionState checkResetForNewLeg(SessionState sessionState, MetricsRouteProgress routeProgress) {
        if (this.shouldResetDepartureDate(routeProgress)) {
            sessionState = sessionState.toBuilder().startTimestamp(null).build();
        }
        return sessionState;
    }

    private boolean shouldResetDepartureDate(MetricsRouteProgress routeProgress) {
        return this.currentLegIndex != routeProgress.getLegIndex();
    }

    private boolean isValidDeparture(SessionState sessionState, MetricsRouteProgress routeProgress) {
        return sessionState.startTimestamp() == null && routeProgress.getDistanceTraveled() > 0;
    }

    private SessionState sendToHandler(SessionState sessionState, MetricsRouteProgress routeProgress, MetricsLocation location) {
        SessionState updatedState = sessionState.toBuilder().startTimestamp(new Date()).build();
        this.departEventHandler.send(updatedState, routeProgress, location);
        return updatedState;
    }
}

