/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.routeprogress;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.Pair;
import com.google.auto.value.AutoValue;
import com.mapbox.api.directions.v5.models.LegStep;
import com.mapbox.api.directions.v5.models.StepIntersection;
import com.mapbox.services.android.navigation.v5.routeprogress.AutoValue_RouteStepProgress;
import java.util.List;

@AutoValue
public abstract class RouteStepProgress {
    public static Builder builder() {
        return new AutoValue_RouteStepProgress.Builder();
    }

    public abstract double distanceRemaining();

    public abstract double distanceTraveled();

    public abstract float fractionTraveled();

    public abstract double durationRemaining();

    public abstract List<StepIntersection> intersections();

    public abstract StepIntersection currentIntersection();

    @Nullable
    public abstract StepIntersection upcomingIntersection();

    public abstract List<Pair<StepIntersection, Double>> intersectionDistancesAlongStep();

    abstract LegStep step();

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder step(LegStep var1);

        abstract LegStep step();

        abstract Builder distanceRemaining(double var1);

        abstract double distanceRemaining();

        abstract Builder distanceTraveled(double var1);

        abstract Builder fractionTraveled(float var1);

        abstract Builder durationRemaining(double var1);

        abstract Builder intersections(@NonNull List<StepIntersection> var1);

        abstract Builder currentIntersection(StepIntersection var1);

        abstract Builder upcomingIntersection(@Nullable StepIntersection var1);

        abstract Builder intersectionDistancesAlongStep(List<Pair<StepIntersection, Double>> var1);

        abstract RouteStepProgress autoBuild();

        RouteStepProgress build() {
            LegStep step = this.step();
            double distanceRemaining = this.distanceRemaining();
            double distanceTraveled = this.calculateDistanceTraveled(step, distanceRemaining);
            this.distanceTraveled(distanceTraveled);
            float fractionTraveled = this.calculateFractionTraveled(step, distanceTraveled);
            this.fractionTraveled(fractionTraveled);
            this.durationRemaining(this.calculateDurationRemaining(step, fractionTraveled));
            return this.autoBuild();
        }

        private double calculateDistanceTraveled(LegStep step, double distanceRemaining) {
            double distanceTraveled = step.distance() - distanceRemaining;
            if (distanceTraveled < 0.0) {
                distanceTraveled = 0.0;
            }
            return distanceTraveled;
        }

        private float calculateFractionTraveled(LegStep step, double distanceTraveled) {
            float fractionTraveled = 1.0f;
            if (step.distance() > 0.0 && (fractionTraveled = (float)(distanceTraveled / step.distance())) < 0.0f) {
                fractionTraveled = 0.0f;
            }
            return fractionTraveled;
        }

        private double calculateDurationRemaining(LegStep step, float fractionTraveled) {
            return (double)(1.0f - fractionTraveled) * step.duration();
        }
    }
}

