/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.location.Location;
import com.mapbox.services.android.navigation.v5.milestone.Milestone;
import com.mapbox.services.android.navigation.v5.navigation.NavigationEventDispatcher;
import com.mapbox.services.android.navigation.v5.navigation.NavigationHelper;
import com.mapbox.services.android.navigation.v5.navigation.NavigationNotificationProvider;
import com.mapbox.services.android.navigation.v5.navigation.RouteProcessorBackgroundThread;
import com.mapbox.services.android.navigation.v5.route.RouteFetcher;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import java.util.List;

class RouteProcessorThreadListener
implements RouteProcessorBackgroundThread.Listener {
    private final NavigationEventDispatcher eventDispatcher;
    private final RouteFetcher routeFetcher;
    private final NavigationNotificationProvider notificationProvider;

    RouteProcessorThreadListener(NavigationEventDispatcher eventDispatcher, RouteFetcher routeFetcher, NavigationNotificationProvider notificationProvider) {
        this.eventDispatcher = eventDispatcher;
        this.routeFetcher = routeFetcher;
        this.notificationProvider = notificationProvider;
    }

    @Override
    public void onNewRouteProgress(Location location, RouteProgress routeProgress) {
        this.notificationProvider.updateNavigationNotification(routeProgress);
        this.eventDispatcher.onProgressChange(location, routeProgress);
    }

    @Override
    public void onMilestoneTrigger(List<Milestone> triggeredMilestones, RouteProgress routeProgress) {
        for (Milestone milestone : triggeredMilestones) {
            String instruction = NavigationHelper.buildInstructionString(routeProgress, milestone);
            this.eventDispatcher.onMilestoneEvent(routeProgress, instruction, milestone);
        }
    }

    @Override
    public void onUserOffRoute(Location location, boolean userOffRoute) {
        if (userOffRoute) {
            this.eventDispatcher.onUserOffRoute(location);
        }
    }

    @Override
    public void onCheckFasterRoute(Location location, RouteProgress routeProgress, boolean checkFasterRoute) {
        if (checkFasterRoute) {
            this.routeFetcher.findRouteFromRouteProgress(location, routeProgress);
        }
    }
}

