/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.os.AsyncTask;
import android.support.annotation.NonNull;
import com.google.gson.Gson;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.navigator.Navigator;
import com.mapbox.navigator.RouterResult;
import com.mapbox.services.android.navigation.v5.navigation.OfflineError;
import com.mapbox.services.android.navigation.v5.navigation.OfflineRoute;
import com.mapbox.services.android.navigation.v5.navigation.OfflineRouteError;
import com.mapbox.services.android.navigation.v5.navigation.OnOfflineRouteFoundCallback;
import timber.log.Timber;

class OfflineRouteRetrievalTask
extends AsyncTask<OfflineRoute, Void, DirectionsRoute> {
    private static final int FIRST_ROUTE = 0;
    private final Navigator navigator;
    private final OnOfflineRouteFoundCallback callback;
    private RouterResult routerResult;

    OfflineRouteRetrievalTask(Navigator navigator, OnOfflineRouteFoundCallback callback) {
        this.navigator = navigator;
        this.callback = callback;
    }

    OfflineRouteRetrievalTask(Navigator navigator, OnOfflineRouteFoundCallback callback, RouterResult routerResult) {
        this(navigator, callback);
        this.routerResult = routerResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DirectionsRoute doInBackground(OfflineRoute ... offlineRoutes) {
        String url = offlineRoutes[0].buildUrl();
        Navigator navigator = this.navigator;
        synchronized (navigator) {
            this.routerResult = this.navigator.getRoute(url);
        }
        return offlineRoutes[0].retrieveOfflineRoute(this.routerResult);
    }

    protected void onPostExecute(DirectionsRoute offlineRoute) {
        if (offlineRoute != null) {
            this.callback.onRouteFound(offlineRoute);
        } else {
            String errorMessage = this.generateErrorMessage();
            OfflineError error = new OfflineError(errorMessage);
            this.callback.onError(error);
        }
    }

    @NonNull
    private String generateErrorMessage() {
        String jsonResponse = this.routerResult.getJson();
        Gson gson = new Gson();
        OfflineRouteError routeError = (OfflineRouteError)gson.fromJson(jsonResponse, OfflineRouteError.class);
        String errorMessage = String.format("Error occurred fetching offline route: %s - Code: %d", routeError.getError(), routeError.getErrorCode());
        Timber.e((String)errorMessage, (Object[])new Object[0]);
        return errorMessage;
    }
}

