/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mapbox.api.directions.v5.models.DirectionsResponse;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.core.exceptions.ServicesException;
import com.mapbox.core.utils.TextUtils;
import com.mapbox.navigator.RouterResult;
import com.mapbox.services.android.navigation.v5.navigation.NavigationRoute;
import java.util.List;
import okhttp3.HttpUrl;

public class OfflineRoute {
    private static final String BICYCLE_TYPE_QUERY_PARAMETER = "bicycle_type";
    private static final String CYCLING_SPEED_QUERY_PARAMETER = "cycling_speed";
    private static final String CYCLEWAY_BIAS_QUERY_PARAMETER = "cycleway_bias";
    private static final String HILL_BIAS_QUERY_PARAMETER = "hill_bias";
    private static final String FERRY_BIAS_QUERY_PARAMETER = "ferry_bias";
    private static final String ROUGH_SURFACE_BIAS_QUERY_PARAMETER = "rough_surface_bias";
    private static final String WAYPOINT_TYPES_QUERY_PARAMETER = "waypoint_types";
    private final NavigationRoute onlineRoute;
    private final String bicycleType;
    private final Float cyclingSpeed;
    private final Float cyclewayBias;
    private final Float hillBias;
    private final Float ferryBias;
    private final Float roughSurfaceBias;
    private final String waypointTypes;

    private OfflineRoute(NavigationRoute onlineRoute, String bicycleType, Float cyclingSpeed, Float cyclewayBias, Float hillBias, Float ferryBias, Float roughSurfaceBias, List<String> waypointTypes) {
        this.onlineRoute = onlineRoute;
        this.bicycleType = this.checkBicycleType(bicycleType);
        this.cyclingSpeed = cyclingSpeed;
        this.cyclewayBias = cyclewayBias;
        this.hillBias = hillBias;
        this.ferryBias = ferryBias;
        this.roughSurfaceBias = roughSurfaceBias;
        this.waypointTypes = this.checkWaypointTypes(waypointTypes);
    }

    public static Builder builder(NavigationRoute.Builder onlineRouteBuilder) {
        return new Builder(onlineRouteBuilder);
    }

    public String buildUrl() {
        String onlineUrl = this.onlineRoute.getCall().request().url().toString();
        String offlineUrl = this.buildOfflineUrl(onlineUrl);
        return offlineUrl;
    }

    @Nullable
    DirectionsRoute retrieveOfflineRoute(@NonNull RouterResult response) {
        boolean success = response.getSuccess();
        if (!this.checkOfflineRoute(success)) {
            return null;
        }
        String jsonResponse = response.getJson();
        return this.obtainRouteFor(jsonResponse);
    }

    private String checkBicycleType(String bicycleType) {
        if (this.isBicycleType(bicycleType)) {
            return bicycleType;
        }
        return null;
    }

    private boolean isBicycleType(String type) {
        if (TextUtils.isEmpty((CharSequence)type)) {
            return false;
        }
        if (!(type.equals("Road") || type.equals("Hybrid") || type.equals("City") || type.equals("Cross") || type.equals("Mountain"))) {
            throw new ServicesException("Bicycle type value must be one of Road, Hybrid, City, Cross or Mountain");
        }
        return true;
    }

    private String checkWaypointTypes(List<String> waypointTypes) {
        if (waypointTypes == null || waypointTypes.isEmpty()) {
            return null;
        }
        String formattedWaypointTypes = this.formatWaypointTypes(waypointTypes);
        if (formattedWaypointTypes == null) {
            throw new ServicesException("All waypoint types values must be one of break, through or null");
        }
        return formattedWaypointTypes;
    }

    private String formatWaypointTypes(List<String> waypointTypesToFormat) {
        Object[] waypointTypes = waypointTypesToFormat.toArray(new String[0]);
        for (int i = 0; i < waypointTypes.length; ++i) {
            if (waypointTypes[i] == null) {
                waypointTypes[i] = "";
                continue;
            }
            if (((String)waypointTypes[i]).equals("break") || ((String)waypointTypes[i]).equals("through") || ((String)waypointTypes[i]).isEmpty()) continue;
            return null;
        }
        return TextUtils.join((CharSequence)";", (Object[])waypointTypes);
    }

    private String buildOfflineUrl(String onlineUrl) {
        HttpUrl.Builder offlineUrlBuilder = HttpUrl.get((String)onlineUrl).newBuilder();
        if (this.bicycleType != null) {
            offlineUrlBuilder.addQueryParameter(BICYCLE_TYPE_QUERY_PARAMETER, this.bicycleType);
        }
        if (this.cyclingSpeed != null) {
            offlineUrlBuilder.addQueryParameter(CYCLING_SPEED_QUERY_PARAMETER, this.cyclingSpeed.toString());
        }
        if (this.cyclewayBias != null) {
            offlineUrlBuilder.addQueryParameter(CYCLEWAY_BIAS_QUERY_PARAMETER, this.cyclewayBias.toString());
        }
        if (this.hillBias != null) {
            offlineUrlBuilder.addQueryParameter(HILL_BIAS_QUERY_PARAMETER, this.hillBias.toString());
        }
        if (this.ferryBias != null) {
            offlineUrlBuilder.addQueryParameter(FERRY_BIAS_QUERY_PARAMETER, this.ferryBias.toString());
        }
        if (this.roughSurfaceBias != null) {
            offlineUrlBuilder.addQueryParameter(ROUGH_SURFACE_BIAS_QUERY_PARAMETER, this.roughSurfaceBias.toString());
        }
        if (this.waypointTypes != null) {
            offlineUrlBuilder.addQueryParameter(WAYPOINT_TYPES_QUERY_PARAMETER, this.waypointTypes);
        }
        return offlineUrlBuilder.build().toString();
    }

    private boolean checkOfflineRoute(boolean isSuccess) {
        return isSuccess;
    }

    private DirectionsRoute obtainRouteFor(String response) {
        DirectionsRoute route = (DirectionsRoute)DirectionsResponse.fromJson((String)response).routes().get(0);
        return route;
    }

    public static final class Builder {
        private final NavigationRoute.Builder navigationRouteBuilder;
        private String bicycleType;
        private Float cyclingSpeed;
        private Float cyclewayBias;
        private Float hillBias;
        private Float ferryBias;
        private Float roughSurfaceBias;
        private List<String> waypointTypes;

        private Builder(NavigationRoute.Builder onlineRouteBuilder) {
            this.navigationRouteBuilder = onlineRouteBuilder;
        }

        public Builder bicycleType(@Nullable String bicycleType) {
            this.bicycleType = bicycleType;
            return this;
        }

        public Builder cyclingSpeed(@Nullable @FloatRange(from=5.0, to=60.0) Float cyclingSpeed) {
            this.cyclingSpeed = cyclingSpeed;
            return this;
        }

        public Builder cyclewayBias(@Nullable @FloatRange(from=-1.0, to=1.0) Float cyclewayBias) {
            this.cyclewayBias = cyclewayBias;
            return this;
        }

        public Builder hillBias(@Nullable @FloatRange(from=-1.0, to=1.0) Float hillBias) {
            this.hillBias = hillBias;
            return this;
        }

        public Builder ferryBias(@Nullable @FloatRange(from=-1.0, to=1.0) Float ferryBias) {
            this.ferryBias = ferryBias;
            return this;
        }

        public Builder roughSurfaceBias(@Nullable @FloatRange(from=-1.0, to=1.0) Float roughSurfaceBias) {
            this.roughSurfaceBias = roughSurfaceBias;
            return this;
        }

        public Builder waypointTypes(@Nullable List<String> waypointTypes) {
            this.waypointTypes = waypointTypes;
            return this;
        }

        public OfflineRoute build() {
            return new OfflineRoute(this.navigationRouteBuilder.build(), this.bicycleType, this.cyclingSpeed, this.cyclewayBias, this.hillBias, this.ferryBias, this.roughSurfaceBias, this.waypointTypes);
        }
    }
}

