/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.content.Context;
import android.location.Location;
import com.mapbox.android.telemetry.AppUserTurnstile;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.FeedbackData;
import com.mapbox.android.telemetry.FeedbackEventData;
import com.mapbox.android.telemetry.MapboxTelemetry;
import com.mapbox.android.telemetry.NavigationCancelData;
import com.mapbox.android.telemetry.NavigationEventFactory;
import com.mapbox.android.telemetry.NavigationLocationData;
import com.mapbox.android.telemetry.NavigationMetadata;
import com.mapbox.android.telemetry.NavigationNewData;
import com.mapbox.android.telemetry.NavigationRerouteData;
import com.mapbox.android.telemetry.NavigationState;
import com.mapbox.android.telemetry.NavigationStepMetadata;
import com.mapbox.services.android.navigation.v5.navigation.InitialGpsEvent;
import com.mapbox.services.android.navigation.v5.navigation.NavigationPerformanceMetadata;
import com.mapbox.services.android.navigation.v5.navigation.RouteRetrievalEvent;
import com.mapbox.services.android.navigation.v5.navigation.metrics.RerouteEvent;
import com.mapbox.services.android.navigation.v5.navigation.metrics.SessionState;
import com.mapbox.services.android.navigation.v5.routeprogress.MetricsRouteProgress;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import com.mapbox.services.android.navigation.v5.utils.DistanceFormatter;
import java.util.Date;
import java.util.List;

final class NavigationMetricsWrapper {
    static String sdkIdentifier;
    private static String upcomingInstruction;
    private static String previousInstruction;
    private static String upcomingModifier;
    private static String previousModifier;
    private static String upcomingType;
    private static String upcomingName;
    private static String previousType;
    private static String previousName;
    private static MapboxTelemetry mapboxTelemetry;

    private NavigationMetricsWrapper() {
    }

    static void init(Context context, String accessToken, String userAgent) {
        mapboxTelemetry = new MapboxTelemetry(context, accessToken, userAgent);
        mapboxTelemetry.enable();
    }

    static void toggleLogging(boolean isDebugLoggingEnabled) {
        mapboxTelemetry.updateDebugLoggingEnabled(isDebugLoggingEnabled);
    }

    static void disable() {
        if (mapboxTelemetry != null) {
            mapboxTelemetry.disable();
        }
    }

    static void push(Event event) {
        mapboxTelemetry.push(event);
    }

    static void arriveEvent(SessionState sessionState, RouteProgress routeProgress, Location location, Context context) {
        Date startTimestamp = NavigationMetricsWrapper.obtainStartTimestamp(sessionState);
        int hardcodedEventVersion = 7;
        MetricsRouteProgress metricsRouteProgress = new MetricsRouteProgress(routeProgress);
        int absoluteDistanceToDestination = DistanceFormatter.calculateAbsoluteDistance(location, metricsRouteProgress);
        NavigationMetadata metadata = new NavigationMetadata(startTimestamp, (int)(sessionState.eventRouteDistanceCompleted() + routeProgress.distanceTraveled()), (int)routeProgress.distanceRemaining(), (int)routeProgress.durationRemaining(), sdkIdentifier, "0.38.1.2", hardcodedEventVersion, sessionState.sessionIdentifier(), location.getLatitude(), location.getLongitude(), sessionState.currentGeometry(), routeProgress.directionsRoute().routeOptions().profile(), sessionState.mockLocation(), sessionState.locationEngineName(), absoluteDistanceToDestination, sessionState.tripIdentifier(), routeProgress.legIndex(), routeProgress.directionsRoute().legs().size(), routeProgress.currentLegProgress().stepIndex(), routeProgress.currentLeg().steps().size(), sessionState.currentStepCount());
        metadata.setEstimatedDistance(Integer.valueOf(routeProgress.directionsRoute().distance().intValue()));
        metadata.setEstimatedDuration(Integer.valueOf(routeProgress.directionsRoute().duration().intValue()));
        metadata.setRerouteCount(Integer.valueOf(sessionState.rerouteCount()));
        metadata.setOriginalRequestIdentifier(sessionState.originalRequestIdentifier());
        metadata.setRequestIdentifier(sessionState.requestIdentifier());
        metadata.setOriginalGeometry(sessionState.originalGeometry());
        metadata.setOriginalEstimatedDistance(Integer.valueOf(sessionState.originalDistance()));
        metadata.setOriginalEstimatedDuration(Integer.valueOf(sessionState.originalDuration()));
        metadata.setOriginalStepCount(Integer.valueOf(sessionState.originalStepCount()));
        metadata.setPercentTimeInForeground(Integer.valueOf(sessionState.percentInForeground()));
        metadata.setPercentTimeInPortrait(Integer.valueOf(sessionState.percentInPortrait()));
        NavigationState state = NavigationState.create((NavigationMetadata)metadata, (Context)context);
        NavigationEventFactory factory = new NavigationEventFactory();
        Event arriveEvent = factory.createNavigationEvent(Event.Type.NAV_ARRIVE, state);
        mapboxTelemetry.push(arriveEvent);
    }

    static void cancelEvent(SessionState sessionState, MetricsRouteProgress metricProgress, Location location, Context context) {
        Date startTimestamp = NavigationMetricsWrapper.obtainStartTimestamp(sessionState);
        int hardcodedEventVersion = 7;
        int absoluteDistanceToDestination = DistanceFormatter.calculateAbsoluteDistance(location, metricProgress);
        NavigationMetadata metadata = new NavigationMetadata(startTimestamp, (int)(sessionState.eventRouteDistanceCompleted() + (double)metricProgress.getDistanceTraveled()), metricProgress.getDistanceRemaining(), metricProgress.getDurationRemaining(), sdkIdentifier, "0.38.1.2", hardcodedEventVersion, sessionState.sessionIdentifier(), location.getLatitude(), location.getLongitude(), sessionState.currentGeometry(), metricProgress.getDirectionsRouteProfile(), sessionState.mockLocation(), sessionState.locationEngineName(), absoluteDistanceToDestination, sessionState.tripIdentifier(), metricProgress.getLegIndex(), metricProgress.getLegCount(), metricProgress.getStepIndex(), metricProgress.getStepCount(), sessionState.currentStepCount());
        metadata.setEstimatedDistance(Integer.valueOf(metricProgress.getDirectionsRouteDistance()));
        metadata.setEstimatedDuration(Integer.valueOf(metricProgress.getDirectionsRouteDuration()));
        metadata.setRerouteCount(Integer.valueOf(sessionState.rerouteCount()));
        metadata.setOriginalRequestIdentifier(sessionState.originalRequestIdentifier());
        metadata.setRequestIdentifier(sessionState.requestIdentifier());
        metadata.setOriginalGeometry(sessionState.originalGeometry());
        metadata.setOriginalEstimatedDistance(Integer.valueOf(sessionState.originalDistance()));
        metadata.setOriginalEstimatedDuration(Integer.valueOf(sessionState.originalDuration()));
        metadata.setOriginalStepCount(Integer.valueOf(sessionState.originalStepCount()));
        metadata.setPercentTimeInForeground(Integer.valueOf(sessionState.percentInForeground()));
        metadata.setPercentTimeInPortrait(Integer.valueOf(sessionState.percentInPortrait()));
        NavigationState state = NavigationState.create((NavigationMetadata)metadata, (Context)context);
        Date arrivalDate = sessionState.arrivalTimestamp();
        NavigationCancelData data = new NavigationCancelData();
        if (arrivalDate != null) {
            data.setArrivalTimestamp(arrivalDate);
        }
        state.setNavigationCancelData(data);
        NavigationEventFactory factory = new NavigationEventFactory();
        Event cancelEvent = factory.createNavigationEvent(Event.Type.NAV_CANCEL, state);
        mapboxTelemetry.push(cancelEvent);
    }

    static void departEvent(SessionState sessionState, MetricsRouteProgress metricProgress, Location location, Context context) {
        Date startTimestamp = NavigationMetricsWrapper.obtainStartTimestamp(sessionState);
        int hardcodedEventVersion = 7;
        int absoluteDistanceToDestination = DistanceFormatter.calculateAbsoluteDistance(location, metricProgress);
        NavigationMetadata metadata = new NavigationMetadata(startTimestamp, metricProgress.getDistanceTraveled(), metricProgress.getDistanceRemaining(), metricProgress.getDurationRemaining(), sdkIdentifier, "0.38.1.2", hardcodedEventVersion, sessionState.sessionIdentifier(), location.getLatitude(), location.getLongitude(), sessionState.currentGeometry(), metricProgress.getDirectionsRouteProfile(), sessionState.mockLocation(), sessionState.locationEngineName(), absoluteDistanceToDestination, sessionState.tripIdentifier(), metricProgress.getLegIndex(), metricProgress.getLegCount(), metricProgress.getStepIndex(), metricProgress.getStepCount(), sessionState.currentStepCount());
        metadata.setEstimatedDistance(Integer.valueOf(metricProgress.getDirectionsRouteDistance()));
        metadata.setEstimatedDuration(Integer.valueOf(metricProgress.getDirectionsRouteDuration()));
        metadata.setRerouteCount(Integer.valueOf(sessionState.rerouteCount()));
        metadata.setOriginalRequestIdentifier(sessionState.originalRequestIdentifier());
        metadata.setRequestIdentifier(sessionState.requestIdentifier());
        metadata.setOriginalGeometry(sessionState.originalGeometry());
        metadata.setOriginalEstimatedDistance(Integer.valueOf(sessionState.originalDistance()));
        metadata.setOriginalEstimatedDuration(Integer.valueOf(sessionState.originalDuration()));
        metadata.setOriginalStepCount(Integer.valueOf(sessionState.originalStepCount()));
        metadata.setPercentTimeInForeground(Integer.valueOf(sessionState.percentInForeground()));
        metadata.setPercentTimeInPortrait(Integer.valueOf(sessionState.percentInPortrait()));
        NavigationState state = NavigationState.create((NavigationMetadata)metadata, (Context)context);
        NavigationEventFactory factory = new NavigationEventFactory();
        Event departEvent = factory.createNavigationEvent(Event.Type.NAV_DEPART, state);
        mapboxTelemetry.push(departEvent);
    }

    static void rerouteEvent(RerouteEvent rerouteEvent, MetricsRouteProgress metricProgress, Location location, Context context) {
        SessionState sessionState = rerouteEvent.getSessionState();
        Date startTimestamp = NavigationMetricsWrapper.obtainStartTimestamp(sessionState);
        int hardcodedEventVersion = 7;
        int absoluteDistanceToDestination = DistanceFormatter.calculateAbsoluteDistance(location, metricProgress);
        NavigationMetadata metadata = new NavigationMetadata(startTimestamp, (int)sessionState.eventRouteDistanceCompleted(), sessionState.eventRouteProgress().getDistanceRemaining(), sessionState.eventRouteProgress().getDurationRemaining(), sdkIdentifier, "0.38.1.2", hardcodedEventVersion, sessionState.sessionIdentifier(), location.getLatitude(), location.getLongitude(), sessionState.currentGeometry(), metricProgress.getDirectionsRouteProfile(), sessionState.mockLocation(), sessionState.locationEngineName(), absoluteDistanceToDestination, sessionState.tripIdentifier(), metricProgress.getLegIndex(), metricProgress.getLegCount(), metricProgress.getStepIndex(), metricProgress.getStepCount(), sessionState.currentStepCount());
        metadata.setEstimatedDistance(Integer.valueOf(metricProgress.getDirectionsRouteDistance()));
        metadata.setEstimatedDuration(Integer.valueOf(metricProgress.getDirectionsRouteDuration()));
        metadata.setRerouteCount(Integer.valueOf(sessionState.rerouteCount()));
        metadata.setOriginalRequestIdentifier(sessionState.originalRequestIdentifier());
        metadata.setRequestIdentifier(sessionState.requestIdentifier());
        metadata.setOriginalGeometry(sessionState.originalGeometry());
        metadata.setOriginalEstimatedDistance(Integer.valueOf(sessionState.originalDistance()));
        metadata.setOriginalEstimatedDuration(Integer.valueOf(sessionState.originalDuration()));
        metadata.setOriginalStepCount(Integer.valueOf(sessionState.originalStepCount()));
        metadata.setPercentTimeInForeground(Integer.valueOf(sessionState.percentInForeground()));
        metadata.setPercentTimeInPortrait(Integer.valueOf(sessionState.percentInPortrait()));
        metadata.setCreated(new Date(location.getTime()));
        NavigationState state = NavigationState.create((NavigationMetadata)metadata, (Context)context);
        Location[] before = NavigationMetricsWrapper.convertToArray(sessionState.beforeEventLocations());
        Location[] after = NavigationMetricsWrapper.convertToArray(sessionState.afterEventLocations());
        NavigationLocationData locationData = new NavigationLocationData(before, after);
        state.setNavigationLocationData(locationData);
        int newDistanceRemaining = rerouteEvent.getNewDistanceRemaining();
        int newDurationRemaining = rerouteEvent.getNewDurationRemaining();
        String newGeometry = rerouteEvent.getNewRouteGeometry();
        NavigationNewData navigationNewData = new NavigationNewData(newDistanceRemaining, newDurationRemaining, newGeometry);
        int secondsSinceLastReroute = sessionState.secondsSinceLastReroute();
        NavigationRerouteData navigationRerouteData = new NavigationRerouteData(navigationNewData, secondsSinceLastReroute);
        state.setNavigationRerouteData(navigationRerouteData);
        FeedbackData feedbackData = new FeedbackData();
        state.setFeedbackData(feedbackData);
        NavigationMetricsWrapper.updateRouteProgressSessionData(metricProgress);
        NavigationStepMetadata navigationStepMetadata = new NavigationStepMetadata();
        navigationStepMetadata.setUpcomingInstruction(upcomingInstruction);
        navigationStepMetadata.setUpcomingType(upcomingType);
        navigationStepMetadata.setUpcomingModifier(upcomingModifier);
        navigationStepMetadata.setUpcomingName(upcomingName);
        navigationStepMetadata.setPreviousInstruction(previousInstruction);
        navigationStepMetadata.setPreviousType(previousType);
        navigationStepMetadata.setPreviousModifier(previousModifier);
        navigationStepMetadata.setPreviousName(previousName);
        int distance = metricProgress.getCurrentStepDistance();
        navigationStepMetadata.setDistance(Integer.valueOf(distance));
        int duration = metricProgress.getCurrentStepDuration();
        navigationStepMetadata.setDuration(Integer.valueOf(duration));
        int stepDistanceRemaining = metricProgress.getCurrentStepDistanceRemaining();
        navigationStepMetadata.setDistanceRemaining(Integer.valueOf(stepDistanceRemaining));
        int stepDurationRemaining = metricProgress.getCurrentStepDurationRemaining();
        navigationStepMetadata.setDurationRemaining(Integer.valueOf(stepDurationRemaining));
        state.setNavigationStepMetadata(navigationStepMetadata);
        NavigationEventFactory factory = new NavigationEventFactory();
        Event navRerouteEvent = factory.createNavigationEvent(Event.Type.NAV_REROUTE, state);
        mapboxTelemetry.push(navRerouteEvent);
    }

    static void feedbackEvent(SessionState sessionState, MetricsRouteProgress metricProgress, Location location, String description, String feedbackType, String screenshot, String feedbackSource, Context context) {
        Date startTimestamp = NavigationMetricsWrapper.obtainStartTimestamp(sessionState);
        int hardcodedEventVersion = 7;
        int absoluteDistanceToDestination = DistanceFormatter.calculateAbsoluteDistance(location, metricProgress);
        NavigationMetadata metadata = new NavigationMetadata(startTimestamp, (int)sessionState.eventRouteDistanceCompleted(), sessionState.eventRouteProgress().getDistanceRemaining(), sessionState.eventRouteProgress().getDurationRemaining(), sdkIdentifier, "0.38.1.2", hardcodedEventVersion, sessionState.sessionIdentifier(), location.getLatitude(), location.getLongitude(), sessionState.currentGeometry(), metricProgress.getDirectionsRouteProfile(), sessionState.mockLocation(), sessionState.locationEngineName(), absoluteDistanceToDestination, sessionState.tripIdentifier(), metricProgress.getLegIndex(), metricProgress.getLegCount(), metricProgress.getStepIndex(), metricProgress.getStepCount(), sessionState.currentStepCount());
        metadata.setEstimatedDistance(Integer.valueOf(metricProgress.getDirectionsRouteDistance()));
        metadata.setEstimatedDuration(Integer.valueOf(metricProgress.getDirectionsRouteDuration()));
        metadata.setRerouteCount(Integer.valueOf(sessionState.rerouteCount()));
        metadata.setOriginalRequestIdentifier(sessionState.originalRequestIdentifier());
        metadata.setRequestIdentifier(sessionState.requestIdentifier());
        metadata.setOriginalGeometry(sessionState.originalGeometry());
        metadata.setOriginalEstimatedDistance(Integer.valueOf(sessionState.originalDistance()));
        metadata.setOriginalEstimatedDuration(Integer.valueOf(sessionState.originalDuration()));
        metadata.setOriginalStepCount(Integer.valueOf(sessionState.originalStepCount()));
        metadata.setPercentTimeInForeground(Integer.valueOf(sessionState.percentInForeground()));
        metadata.setPercentTimeInPortrait(Integer.valueOf(sessionState.percentInPortrait()));
        metadata.setCreated(new Date(location.getTime()));
        NavigationState state = NavigationState.create((NavigationMetadata)metadata, (Context)context);
        Location[] before = NavigationMetricsWrapper.convertToArray(sessionState.beforeEventLocations());
        Location[] after = NavigationMetricsWrapper.convertToArray(sessionState.afterEventLocations());
        NavigationLocationData locationData = new NavigationLocationData(before, after);
        state.setNavigationLocationData(locationData);
        FeedbackData feedbackData = new FeedbackData();
        feedbackData.setScreenshot(screenshot);
        state.setFeedbackData(feedbackData);
        NavigationMetricsWrapper.updateRouteProgressSessionData(metricProgress);
        NavigationStepMetadata navigationStepMetadata = new NavigationStepMetadata();
        navigationStepMetadata.setUpcomingInstruction(upcomingInstruction);
        navigationStepMetadata.setUpcomingType(upcomingType);
        navigationStepMetadata.setUpcomingModifier(upcomingModifier);
        navigationStepMetadata.setUpcomingName(upcomingName);
        navigationStepMetadata.setPreviousInstruction(previousInstruction);
        navigationStepMetadata.setPreviousType(previousType);
        navigationStepMetadata.setPreviousModifier(previousModifier);
        navigationStepMetadata.setPreviousName(previousName);
        int distance = metricProgress.getCurrentStepDistance();
        navigationStepMetadata.setDistance(Integer.valueOf(distance));
        int duration = metricProgress.getCurrentStepDuration();
        navigationStepMetadata.setDuration(Integer.valueOf(duration));
        int stepDistanceRemaining = metricProgress.getCurrentStepDistanceRemaining();
        navigationStepMetadata.setDistanceRemaining(Integer.valueOf(stepDistanceRemaining));
        int stepDurationRemaining = metricProgress.getCurrentStepDurationRemaining();
        navigationStepMetadata.setDurationRemaining(Integer.valueOf(stepDurationRemaining));
        state.setNavigationStepMetadata(navigationStepMetadata);
        FeedbackEventData feedbackEventData = new FeedbackEventData(feedbackType, feedbackSource);
        feedbackEventData.setDescription(description);
        state.setFeedbackEventData(feedbackEventData);
        NavigationEventFactory factory = new NavigationEventFactory();
        Event feedbackEvent = factory.createNavigationEvent(Event.Type.NAV_FEEDBACK, state);
        mapboxTelemetry.push(feedbackEvent);
    }

    static void routeRetrievalEvent(double elapsedTime, String routeUuid, String sessionId, NavigationPerformanceMetadata metadata) {
        NavigationMetricsWrapper.push(new RouteRetrievalEvent(elapsedTime, routeUuid, sessionId, metadata));
    }

    static void sendInitialGpsEvent(double elapsedTime, String sessionId) {
        NavigationMetricsWrapper.push(new InitialGpsEvent(elapsedTime, sessionId));
    }

    static Event turnstileEvent() {
        AppUserTurnstile navTurnstileEvent = new AppUserTurnstile(sdkIdentifier, "0.38.1.2");
        return navTurnstileEvent;
    }

    private static Date obtainStartTimestamp(SessionState sessionState) {
        if (sessionState.startTimestamp() == null) {
            return new Date();
        }
        return sessionState.startTimestamp();
    }

    private static void updateRouteProgressSessionData(MetricsRouteProgress routeProgress) {
        upcomingName = routeProgress.getUpcomingStepName();
        upcomingInstruction = routeProgress.getUpcomingStepInstruction();
        upcomingType = routeProgress.getUpcomingStepType();
        upcomingModifier = routeProgress.getUpcomingStepModifier();
        previousInstruction = routeProgress.getPreviousStepInstruction();
        previousType = routeProgress.getPreviousStepType();
        previousModifier = routeProgress.getPreviousStepModifier();
        previousName = routeProgress.getPreviousStepName();
    }

    private static Location[] convertToArray(List<Location> locationList) {
        return locationList.toArray(new Location[locationList.size()]);
    }
}

