/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.utils.time;

import android.content.Context;
import android.content.res.Resources;
import android.text.SpannableStringBuilder;
import android.text.style.RelativeSizeSpan;
import android.text.style.StyleSpan;
import com.mapbox.services.android.navigation.R;
import com.mapbox.services.android.navigation.v5.utils.span.SpanItem;
import com.mapbox.services.android.navigation.v5.utils.span.SpanUtils;
import com.mapbox.services.android.navigation.v5.utils.span.TextSpanItem;
import com.mapbox.services.android.navigation.v5.utils.time.TimeFormattingChain;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.TimeUnit;
import timber.log.Timber;

public class TimeFormatter {
    private static final String TIME_STRING_FORMAT = " %s ";

    public static String formatTime(Calendar time, double routeDuration, int type, boolean isDeviceTwentyFourHourFormat) {
        time.add(13, (int)routeDuration);
        TimeFormattingChain chain = new TimeFormattingChain();
        return chain.setup(isDeviceTwentyFourHourFormat).obtainTimeFormatted(type, time);
    }

    public static SpannableStringBuilder formatTimeRemaining(Context context, double routeDuration) {
        long minutes;
        long seconds = (long)routeDuration;
        if (seconds < 0L) {
            Timber.e((String)"Duration must be greater than zero. Invalid duration %s", (Object[])new Object[]{seconds});
            seconds = 0L;
        }
        long days = TimeUnit.SECONDS.toDays(seconds);
        long hours = TimeUnit.SECONDS.toHours(seconds -= TimeUnit.DAYS.toSeconds(days));
        seconds -= TimeUnit.HOURS.toSeconds(hours);
        if ((seconds -= TimeUnit.MINUTES.toSeconds(minutes = TimeUnit.SECONDS.toMinutes(seconds))) >= 30L) {
            ++minutes;
        }
        ArrayList<SpanItem> textSpanItems = new ArrayList<SpanItem>();
        Resources resources = context.getResources();
        TimeFormatter.formatDays(resources, days, textSpanItems);
        TimeFormatter.formatHours(context, hours, textSpanItems);
        TimeFormatter.formatMinutes(context, minutes, textSpanItems);
        TimeFormatter.formatNoData(context, days, hours, minutes, textSpanItems);
        return SpanUtils.combineSpans(textSpanItems);
    }

    private static void formatDays(Resources resources, long days, List<SpanItem> textSpanItems) {
        if (days != 0L) {
            String dayQuantityString = resources.getQuantityString(R.plurals.numberOfDays, (int)days);
            String dayString = String.format(TIME_STRING_FORMAT, dayQuantityString);
            textSpanItems.add(new TextSpanItem(new StyleSpan(1), String.valueOf(days)));
            textSpanItems.add(new TextSpanItem(new RelativeSizeSpan(1.0f), dayString));
        }
    }

    private static void formatHours(Context context, long hours, List<SpanItem> textSpanItems) {
        if (hours != 0L) {
            String hourString = String.format(TIME_STRING_FORMAT, context.getString(R.string.hr));
            textSpanItems.add(new TextSpanItem(new StyleSpan(1), String.valueOf(hours)));
            textSpanItems.add(new TextSpanItem(new RelativeSizeSpan(1.0f), hourString));
        }
    }

    private static void formatMinutes(Context context, long minutes, List<SpanItem> textSpanItems) {
        if (minutes != 0L) {
            String minuteString = String.format(TIME_STRING_FORMAT, context.getString(R.string.min));
            textSpanItems.add(new TextSpanItem(new StyleSpan(1), String.valueOf(minutes)));
            textSpanItems.add(new TextSpanItem(new RelativeSizeSpan(1.0f), minuteString));
        }
    }

    private static void formatNoData(Context context, long days, long hours, long minutes, List<SpanItem> textSpanItems) {
        if (days == 0L && hours == 0L && minutes == 0L) {
            String minuteString = String.format(TIME_STRING_FORMAT, context.getString(R.string.min));
            textSpanItems.add(new TextSpanItem(new StyleSpan(1), String.valueOf(1)));
            textSpanItems.add(new TextSpanItem(new RelativeSizeSpan(1.0f), minuteString));
        }
    }
}

