/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.api.directionsrefresh.v1.models.DirectionsRefreshResponse;
import com.mapbox.services.android.navigation.v5.navigation.RefreshCallback;
import com.mapbox.services.android.navigation.v5.navigation.RefreshError;
import com.mapbox.services.android.navigation.v5.navigation.RouteAnnotationUpdater;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

class RouteRefreshCallback
implements Callback<DirectionsRefreshResponse> {
    private final RouteAnnotationUpdater routeAnnotationUpdater;
    private final DirectionsRoute directionsRoute;
    private final int legIndex;
    private final RefreshCallback refreshCallback;

    RouteRefreshCallback(DirectionsRoute directionsRoute, int legIndex, RefreshCallback refreshCallback) {
        this(new RouteAnnotationUpdater(), directionsRoute, legIndex, refreshCallback);
    }

    RouteRefreshCallback(RouteAnnotationUpdater routeAnnotationUpdater, DirectionsRoute directionsRoute, int legIndex, RefreshCallback refreshCallback) {
        this.routeAnnotationUpdater = routeAnnotationUpdater;
        this.directionsRoute = directionsRoute;
        this.legIndex = legIndex;
        this.refreshCallback = refreshCallback;
    }

    public void onResponse(Call<DirectionsRefreshResponse> call, Response<DirectionsRefreshResponse> response) {
        if (response.body() == null || ((DirectionsRefreshResponse)response.body()).route() == null || ((DirectionsRefreshResponse)response.body()).route().legs() == null) {
            this.refreshCallback.onError(new RefreshError(response.message()));
        } else {
            this.refreshCallback.onRefresh(this.routeAnnotationUpdater.update(this.directionsRoute, ((DirectionsRefreshResponse)response.body()).route(), this.legIndex));
        }
    }

    public void onFailure(Call<DirectionsRefreshResponse> call, Throwable throwable) {
        this.refreshCallback.onError(new RefreshError(throwable.getMessage()));
    }
}

