/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import com.mapbox.api.routetiles.v1.MapboxRouteTiles;
import com.mapbox.geojson.BoundingBox;
import retrofit2.Callback;

public class OfflineTiles {
    private final MapboxRouteTiles mapboxRouteTiles;
    private final String version;

    private OfflineTiles(MapboxRouteTiles mapboxRouteTiles, String version) {
        this.mapboxRouteTiles = mapboxRouteTiles;
        this.version = version;
    }

    public static Builder builder() {
        return new Builder();
    }

    void fetchRouteTiles(Callback callback) {
        this.mapboxRouteTiles.enqueueCall(callback);
    }

    public String version() {
        return this.version;
    }

    public static class Builder {
        private final MapboxRouteTiles.Builder mapboxRouteTilesBuilder = MapboxRouteTiles.builder();
        private String version;

        Builder() {
        }

        public Builder version(String version) {
            this.version = version;
            this.mapboxRouteTilesBuilder.version(version);
            return this;
        }

        public Builder accessToken(String accessToken) {
            this.mapboxRouteTilesBuilder.accessToken(accessToken);
            return this;
        }

        public Builder boundingBox(BoundingBox boundingBox) {
            this.mapboxRouteTilesBuilder.boundingBox(boundingBox);
            return this;
        }

        public OfflineTiles build() {
            return new OfflineTiles(this.mapboxRouteTilesBuilder.build(), this.version);
        }
    }
}

