/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import com.mapbox.services.android.navigation.v5.navigation.camera.Camera;
import com.mapbox.services.android.navigation.v5.navigation.camera.SimpleCamera;
import com.mapbox.services.android.navigation.v5.offroute.OffRoute;
import com.mapbox.services.android.navigation.v5.offroute.OffRouteDetector;
import com.mapbox.services.android.navigation.v5.route.FasterRoute;
import com.mapbox.services.android.navigation.v5.route.FasterRouteDetector;
import com.mapbox.services.android.navigation.v5.snap.Snap;
import com.mapbox.services.android.navigation.v5.snap.SnapToRoute;

class NavigationEngineFactory {
    private OffRoute offRouteEngine;
    private FasterRoute fasterRouteEngine;
    private Snap snapEngine;
    private Camera cameraEngine;

    NavigationEngineFactory() {
        this.initializeDefaultEngines();
    }

    OffRoute retrieveOffRouteEngine() {
        return this.offRouteEngine;
    }

    void updateOffRouteEngine(OffRoute offRouteEngine) {
        if (offRouteEngine == null) {
            return;
        }
        this.offRouteEngine = offRouteEngine;
    }

    FasterRoute retrieveFasterRouteEngine() {
        return this.fasterRouteEngine;
    }

    void updateFasterRouteEngine(FasterRoute fasterRouteEngine) {
        if (fasterRouteEngine == null) {
            return;
        }
        this.fasterRouteEngine = fasterRouteEngine;
    }

    Snap retrieveSnapEngine() {
        return this.snapEngine;
    }

    void updateSnapEngine(Snap snapEngine) {
        if (snapEngine == null) {
            return;
        }
        this.snapEngine = snapEngine;
    }

    Camera retrieveCameraEngine() {
        return this.cameraEngine;
    }

    void updateCameraEngine(Camera cameraEngine) {
        if (cameraEngine == null) {
            return;
        }
        this.cameraEngine = cameraEngine;
    }

    private void initializeDefaultEngines() {
        this.cameraEngine = new SimpleCamera();
        this.snapEngine = new SnapToRoute();
        this.offRouteEngine = new OffRouteDetector();
        this.fasterRouteEngine = new FasterRouteDetector();
    }
}

