/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.v4.app.NotificationCompat;
import android.support.v4.content.ContextCompat;
import android.text.SpannableString;
import android.text.format.DateFormat;
import android.widget.RemoteViews;
import com.mapbox.api.directions.v5.models.BannerInstructions;
import com.mapbox.api.directions.v5.models.LegStep;
import com.mapbox.api.directions.v5.models.RouteOptions;
import com.mapbox.services.android.navigation.R;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigation;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigationOptions;
import com.mapbox.services.android.navigation.v5.navigation.notification.NavigationNotification;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import com.mapbox.services.android.navigation.v5.utils.DistanceFormatter;
import com.mapbox.services.android.navigation.v5.utils.LocaleUtils;
import com.mapbox.services.android.navigation.v5.utils.ManeuverUtils;
import com.mapbox.services.android.navigation.v5.utils.time.TimeFormatter;
import java.util.Calendar;

class MapboxNavigationNotification
implements NavigationNotification {
    private static final String END_NAVIGATION_ACTION = "com.mapbox.intent.action.END_NAVIGATION";
    private static final String SET_BACKGROUND_COLOR = "setBackgroundColor";
    private NotificationManager notificationManager;
    private Notification notification;
    private RemoteViews collapsedNotificationRemoteViews;
    private RemoteViews expandedNotificationRemoteViews;
    private MapboxNavigation mapboxNavigation;
    private SpannableString currentDistanceText;
    private DistanceFormatter distanceFormatter;
    private String instructionText;
    private int currentManeuverId;
    private boolean isTwentyFourHourFormat;
    private String etaFormat;
    private final Context applicationContext;
    private PendingIntent pendingOpenIntent;
    private PendingIntent pendingCloseIntent;
    private BroadcastReceiver endNavigationBtnReceiver = new BroadcastReceiver(){

        public void onReceive(Context applicationContext, Intent intent) {
            MapboxNavigationNotification.this.onEndNavigationBtnClick();
        }
    };

    MapboxNavigationNotification(Context applicationContext, MapboxNavigation mapboxNavigation) {
        this.applicationContext = applicationContext;
        this.initialize(applicationContext, mapboxNavigation);
    }

    MapboxNavigationNotification(Context applicationContext, MapboxNavigation mapboxNavigation, Notification notification) {
        this.applicationContext = applicationContext;
        this.notification = notification;
        this.initialize(applicationContext, mapboxNavigation);
    }

    @Override
    public Notification getNotification() {
        return this.notification;
    }

    @Override
    public int getNotificationId() {
        return 5678;
    }

    @Override
    public void updateNotification(RouteProgress routeProgress) {
        this.updateNotificationViews(routeProgress);
        this.rebuildNotification();
    }

    @Override
    public void onNavigationStopped(Context applicationContext) {
        this.unregisterReceiver(applicationContext);
    }

    String generateArrivalTime(RouteProgress routeProgress, Calendar time) {
        MapboxNavigationOptions options = this.mapboxNavigation.options();
        double legDurationRemaining = routeProgress.currentLegProgress().durationRemaining();
        int timeFormatType = options.timeFormatType();
        String arrivalTime = TimeFormatter.formatTime(time, legDurationRemaining, timeFormatType, this.isTwentyFourHourFormat);
        String formattedArrivalTime = String.format(this.etaFormat, arrivalTime);
        return formattedArrivalTime;
    }

    private void initialize(Context applicationContext, MapboxNavigation mapboxNavigation) {
        this.mapboxNavigation = mapboxNavigation;
        this.etaFormat = applicationContext.getString(R.string.eta_format);
        this.initializeDistanceFormatter(applicationContext, mapboxNavigation);
        this.notificationManager = (NotificationManager)applicationContext.getSystemService("notification");
        this.isTwentyFourHourFormat = DateFormat.is24HourFormat((Context)applicationContext);
        this.pendingOpenIntent = this.createPendingOpenIntent(applicationContext);
        this.pendingCloseIntent = this.createPendingCloseIntent(applicationContext);
        this.registerReceiver(applicationContext);
        this.createNotificationChannel(applicationContext);
        if (this.notification == null) {
            this.notification = this.buildNotification(applicationContext);
        }
    }

    private void initializeDistanceFormatter(Context applicationContext, MapboxNavigation mapboxNavigation) {
        RouteOptions routeOptions = mapboxNavigation.getRoute().routeOptions();
        LocaleUtils localeUtils = new LocaleUtils();
        String language = localeUtils.inferDeviceLanguage(applicationContext);
        String unitType = localeUtils.getUnitTypeForDeviceLocale(applicationContext);
        if (routeOptions != null) {
            language = routeOptions.language();
            unitType = routeOptions.voiceUnits();
        }
        MapboxNavigationOptions mapboxNavigationOptions = mapboxNavigation.options();
        int roundingIncrement = mapboxNavigationOptions.roundingIncrement();
        this.distanceFormatter = new DistanceFormatter(applicationContext, language, unitType, roundingIncrement);
    }

    private void createNotificationChannel(Context applicationContext) {
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel notificationChannel = new NotificationChannel("NAVIGATION_NOTIFICATION_CHANNEL", (CharSequence)applicationContext.getString(R.string.channel_name), 2);
            this.notificationManager.createNotificationChannel(notificationChannel);
        }
    }

    private Notification buildNotification(Context applicationContext) {
        String channelId = "NAVIGATION_NOTIFICATION_CHANNEL";
        NotificationCompat.Builder builder = new NotificationCompat.Builder(applicationContext, channelId).setCategory("service").setPriority(2).setSmallIcon(R.drawable.ic_navigation).setCustomContentView(this.collapsedNotificationRemoteViews).setCustomBigContentView(this.expandedNotificationRemoteViews).setOngoing(true);
        if (this.pendingOpenIntent != null) {
            builder.setContentIntent(this.pendingOpenIntent);
        }
        return builder.build();
    }

    private void buildRemoteViews() {
        int colorResId = this.mapboxNavigation.options().defaultNotificationColorId();
        int backgroundColor = ContextCompat.getColor((Context)this.applicationContext, (int)colorResId);
        int collapsedLayout = R.layout.collapsed_navigation_notification_layout;
        int collapsedLayoutId = R.id.navigationCollapsedNotificationLayout;
        this.collapsedNotificationRemoteViews = new RemoteViews(this.applicationContext.getPackageName(), collapsedLayout);
        this.collapsedNotificationRemoteViews.setInt(collapsedLayoutId, SET_BACKGROUND_COLOR, backgroundColor);
        int expandedLayout = R.layout.expanded_navigation_notification_layout;
        int expandedLayoutId = R.id.navigationExpandedNotificationLayout;
        this.expandedNotificationRemoteViews = new RemoteViews(this.applicationContext.getPackageName(), expandedLayout);
        this.expandedNotificationRemoteViews.setOnClickPendingIntent(R.id.endNavigationBtn, this.pendingCloseIntent);
        this.expandedNotificationRemoteViews.setInt(expandedLayoutId, SET_BACKGROUND_COLOR, backgroundColor);
    }

    @Nullable
    private PendingIntent createPendingOpenIntent(Context applicationContext) {
        PackageManager pm = applicationContext.getPackageManager();
        Intent intent = pm.getLaunchIntentForPackage(applicationContext.getPackageName());
        if (intent == null) {
            return null;
        }
        intent.setPackage(null);
        return PendingIntent.getActivity((Context)applicationContext, (int)0, (Intent)intent, (int)0);
    }

    private PendingIntent createPendingCloseIntent(Context applicationContext) {
        Intent endNavigationBtn = new Intent(END_NAVIGATION_ACTION);
        return PendingIntent.getBroadcast((Context)applicationContext, (int)0, (Intent)endNavigationBtn, (int)0);
    }

    private void registerReceiver(Context applicationContext) {
        if (applicationContext != null) {
            applicationContext.registerReceiver(this.endNavigationBtnReceiver, new IntentFilter(END_NAVIGATION_ACTION));
        }
    }

    private void updateNotificationViews(RouteProgress routeProgress) {
        this.buildRemoteViews();
        this.updateInstructionText(routeProgress.currentLegProgress().currentStep());
        this.updateDistanceText(routeProgress);
        Calendar time = Calendar.getInstance();
        String formattedArrivalTime = this.generateArrivalTime(routeProgress, time);
        this.updateViewsWith(formattedArrivalTime);
        LegStep step = routeProgress.currentLegProgress().upComingStep() != null ? routeProgress.currentLegProgress().upComingStep() : routeProgress.currentLegProgress().currentStep();
        this.updateManeuverImage(step);
    }

    private void rebuildNotification() {
        this.notification = this.buildNotification(this.applicationContext);
        this.notificationManager.notify(5678, this.notification);
    }

    private void unregisterReceiver(Context applicationContext) {
        if (applicationContext != null) {
            applicationContext.unregisterReceiver(this.endNavigationBtnReceiver);
        }
        if (this.notificationManager != null) {
            this.notificationManager.cancel(5678);
        }
    }

    private void updateInstructionText(LegStep step) {
        if (this.hasInstructions(step) && (this.instructionText == null || this.newInstructionText(step))) {
            this.instructionText = ((BannerInstructions)step.bannerInstructions().get(0)).primary().text();
            this.collapsedNotificationRemoteViews.setTextViewText(R.id.notificationInstructionText, (CharSequence)this.instructionText);
            this.expandedNotificationRemoteViews.setTextViewText(R.id.notificationInstructionText, (CharSequence)this.instructionText);
        }
    }

    private boolean hasInstructions(LegStep step) {
        return step.bannerInstructions() != null && !step.bannerInstructions().isEmpty();
    }

    private boolean newInstructionText(LegStep step) {
        return !this.instructionText.equals(((BannerInstructions)step.bannerInstructions().get(0)).primary().text());
    }

    private void updateDistanceText(RouteProgress routeProgress) {
        if (this.currentDistanceText == null || this.newDistanceText(routeProgress)) {
            this.currentDistanceText = this.distanceFormatter.formatDistance(routeProgress.currentLegProgress().currentStepProgress().distanceRemaining());
            this.collapsedNotificationRemoteViews.setTextViewText(R.id.notificationDistanceText, (CharSequence)this.currentDistanceText);
            this.expandedNotificationRemoteViews.setTextViewText(R.id.notificationDistanceText, (CharSequence)this.currentDistanceText);
        }
    }

    private boolean newDistanceText(RouteProgress routeProgress) {
        return this.currentDistanceText != null && !this.currentDistanceText.toString().equals(this.distanceFormatter.formatDistance(routeProgress.currentLegProgress().currentStepProgress().distanceRemaining()).toString());
    }

    private void updateViewsWith(String formattedArrivalTime) {
        this.collapsedNotificationRemoteViews.setTextViewText(R.id.notificationArrivalText, (CharSequence)formattedArrivalTime);
        this.expandedNotificationRemoteViews.setTextViewText(R.id.notificationArrivalText, (CharSequence)formattedArrivalTime);
    }

    private void updateManeuverImage(LegStep step) {
        if (this.newManeuverId(step)) {
            int maneuverResource;
            this.currentManeuverId = maneuverResource = ManeuverUtils.getManeuverResource(step);
            this.collapsedNotificationRemoteViews.setImageViewResource(R.id.maneuverImage, maneuverResource);
            this.expandedNotificationRemoteViews.setImageViewResource(R.id.maneuverImage, maneuverResource);
        }
    }

    private boolean newManeuverId(LegStep step) {
        return this.currentManeuverId != ManeuverUtils.getManeuverResource(step);
    }

    private void onEndNavigationBtnClick() {
        if (this.mapboxNavigation != null) {
            this.mapboxNavigation.stopNavigation();
        }
    }
}

