/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.mapbox.services.android.navigation.v5.navigation.SdkVersionChecker;

class BatteryMonitor {
    private static final int UNAVAILABLE_BATTERY_LEVEL = -1;
    private static final int DEFAULT_BATTERY_LEVEL = -1;
    private static final int DEFAULT_SCALE = 100;
    private static final float PERCENT_SCALE = 100.0f;
    private final SdkVersionChecker currentVersionChecker;

    BatteryMonitor(SdkVersionChecker currentVersionChecker) {
        this.currentVersionChecker = currentVersionChecker;
    }

    float obtainPercentage(Context context) {
        Intent batteryStatus = this.registerBatteryUpdates(context);
        if (batteryStatus == null) {
            return -1.0f;
        }
        int level = batteryStatus.getIntExtra("level", -1);
        int scale = batteryStatus.getIntExtra("scale", 100);
        return (float)level / (float)scale * 100.0f;
    }

    boolean isPluggedIn(Context context) {
        Intent batteryStatus = this.registerBatteryUpdates(context);
        if (batteryStatus == null) {
            return false;
        }
        int chargePlug = batteryStatus.getIntExtra("plugged", -1);
        boolean pluggedUsb = chargePlug == 2;
        boolean pluggedAc = chargePlug == 1;
        boolean pluggedWireless = false;
        if (this.currentVersionChecker.isGreaterThan(16)) {
            pluggedWireless = chargePlug == 4;
        }
        boolean isPlugged = pluggedUsb || pluggedAc || pluggedWireless;
        return isPlugged;
    }

    private Intent registerBatteryUpdates(Context context) {
        IntentFilter filter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        return context.registerReceiver(null, filter);
    }
}

