/*
 * Decompiled with CFR 0.152.
 */
package org.hybridsquad.android.library;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.hybridsquad.android.library.CropParams;

public class CompressImageUtils {
    public static final String TAG = "ChoosePhotoUtils";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compressImageFile(CropParams cropParams, Uri originUri, Uri compressUri) {
        Bitmap bitmap = null;
        OutputStream out = null;
        try {
            boolean result;
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)originUri.getPath(), (BitmapFactory.Options)options);
            int minSideLength = cropParams.compressWidth > cropParams.compressHeight ? cropParams.compressHeight : cropParams.compressWidth;
            options.inSampleSize = CompressImageUtils.computeSampleSize(options, minSideLength, cropParams.compressWidth * cropParams.compressHeight);
            options.inJustDecodeBounds = false;
            bitmap = BitmapFactory.decodeFile((String)originUri.getPath(), (BitmapFactory.Options)options);
            File compressFile = new File(compressUri.getPath());
            if (!compressFile.exists()) {
                result = compressFile.createNewFile();
                Log.d((String)TAG, (String)("Target " + compressUri + " not exist, create a new one " + result));
            }
            out = new FileOutputStream(compressFile);
            result = bitmap.compress(Bitmap.CompressFormat.JPEG, cropParams.compressQuality, out);
            Log.d((String)TAG, (String)("Compress bitmap " + (result ? "succeed" : "failed")));
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"compressInputStreamToOutputStream", (Throwable)e);
        }
        finally {
            if (bitmap != null) {
                bitmap.recycle();
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ignore) {}
        }
    }

    public static int computeSampleSize(BitmapFactory.Options options, int minSideLength, int maxNumOfPixels) {
        int roundedSize;
        int initialSize = CompressImageUtils.computeInitialSampleSize(options, minSideLength, maxNumOfPixels);
        if (initialSize <= 8) {
            for (roundedSize = 1; roundedSize < initialSize; roundedSize <<= 1) {
            }
        } else {
            roundedSize = (initialSize + 7) / 8 * 8;
        }
        return roundedSize;
    }

    private static int computeInitialSampleSize(BitmapFactory.Options options, int minSideLength, int maxNumOfPixels) {
        int upperBound;
        double w = options.outWidth;
        double h = options.outHeight;
        int lowerBound = maxNumOfPixels == -1 ? 1 : (int)Math.ceil(Math.sqrt(w * h / (double)maxNumOfPixels));
        int n = upperBound = minSideLength == -1 ? 128 : (int)Math.min(Math.floor(w / (double)minSideLength), Math.floor(h / (double)minSideLength));
        if (upperBound < lowerBound) {
            return lowerBound;
        }
        if (maxNumOfPixels == -1 && minSideLength == -1) {
            return 1;
        }
        if (minSideLength == -1) {
            return lowerBound;
        }
        return upperBound;
    }
}

