/*
 * Decompiled with CFR 0.152.
 */
package org.hybridsquad.android.library;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Environment;
import android.os.Parcelable;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.hybridsquad.android.library.CropFileUtils;
import org.hybridsquad.android.library.CropHandler;
import org.hybridsquad.android.library.CropParams;

public class CropHelper {
    public static final String TAG = "CropHelper";
    public static final int REQUEST_CROP = 127;
    public static final int REQUEST_CAMERA = 128;
    public static final int REQUEST_PICK = 129;
    public static final String CROP_CACHE_FILE_NAME = "crop_cache_file.jpg";

    public static Uri buildUri() {
        return Uri.fromFile((File)Environment.getExternalStorageDirectory()).buildUpon().appendPath(CROP_CACHE_FILE_NAME).build();
    }

    public static void handleResult(CropHandler handler, int requestCode, int resultCode, Intent data) {
        if (handler == null) {
            return;
        }
        if (resultCode == 0) {
            handler.onCropCancel();
        } else if (resultCode == -1) {
            CropParams cropParams = handler.getCropParams();
            if (cropParams == null) {
                handler.onCropFailed("CropHandler's params MUST NOT be null!");
                return;
            }
            switch (requestCode) {
                case 127: 
                case 129: {
                    if (CropHelper.isPhotoReallyCropped(cropParams.uri)) {
                        Log.d((String)TAG, (String)"Photo cropped!");
                        handler.onPhotoCropped(cropParams.uri);
                        break;
                    }
                    Activity context = handler.getContext();
                    if (context != null) {
                        String path = CropFileUtils.getSmartFilePath((Context)context, data.getData());
                        boolean result = CropFileUtils.copyFile(path, cropParams.uri.getPath());
                        if (!result) {
                            handler.onCropFailed("Unknown error occurred!");
                            break;
                        }
                    } else {
                        handler.onCropFailed("CropHandler's context MUST NOT be null!");
                    }
                }
                case 128: {
                    if (cropParams.enable) {
                        Intent intent = CropHelper.buildCropFromUriIntent(cropParams);
                        Activity context = handler.getContext();
                        if (context != null) {
                            context.startActivityForResult(intent, 127);
                            break;
                        }
                        handler.onCropFailed("CropHandler's context MUST NOT be null!");
                        break;
                    }
                    Log.d((String)TAG, (String)"Photo cropped!");
                    handler.onPhotoCropped(cropParams.uri);
                }
            }
        }
    }

    public static boolean isPhotoReallyCropped(Uri uri) {
        File file = new File(uri.getPath());
        long length = file.length();
        return length > 0L;
    }

    public static boolean clearCachedCropFile(Uri uri) {
        if (uri == null) {
            return false;
        }
        File file = new File(uri.getPath());
        if (file.exists()) {
            boolean result = file.delete();
            if (result) {
                Log.i((String)TAG, (String)"Cached crop file cleared.");
            } else {
                Log.e((String)TAG, (String)"Failed to clear cached crop file.");
            }
            return result;
        }
        Log.w((String)TAG, (String)"Trying to clear cached crop file but it does not exist.");
        return false;
    }

    public static Intent buildCropFromUriIntent(CropParams params) {
        return CropHelper.buildCropIntent("com.android.camera.action.CROP", params);
    }

    public static Intent buildCropFromGalleryIntent(CropParams params) {
        return CropHelper.buildCropIntent("android.intent.action.GET_CONTENT", params);
    }

    public static Intent buildCaptureIntent(Uri uri) {
        return new Intent("android.media.action.IMAGE_CAPTURE").putExtra("output", (Parcelable)uri);
    }

    public static Intent buildPickIntent(Uri uri) {
        return new Intent("android.intent.action.GET_CONTENT").setType("image/*").putExtra("output", (Parcelable)uri);
    }

    public static Intent buildCropIntent(String action, CropParams params) {
        return new Intent(action, null).setDataAndType(params.uri, params.type).putExtra("crop", params.crop).putExtra("scale", params.scale).putExtra("aspectX", params.aspectX).putExtra("aspectY", params.aspectY).putExtra("outputX", params.outputX).putExtra("outputY", params.outputY).putExtra("return-data", params.returnData).putExtra("outputFormat", params.outputFormat).putExtra("noFaceDetection", params.noFaceDetection).putExtra("scaleUpIfNeeded", params.scaleUpIfNeeded).putExtra("output", (Parcelable)params.uri);
    }

    public static Bitmap decodeUriAsBitmap(Context context, Uri uri) {
        Bitmap bitmap;
        if (context == null || uri == null) {
            return null;
        }
        try {
            bitmap = BitmapFactory.decodeStream((InputStream)context.getContentResolver().openInputStream(uri));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        return bitmap;
    }
}

