/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testng.util;

import java.util.concurrent.TimeUnit;

public class FormatUtil {
    public static String formatTimeInMilliSeconds(long duration) {
        if (duration == 0L) {
            return "0 msec";
        }
        try {
            StringBuffer durationInString = new StringBuffer("");
            long hours = TimeUnit.MILLISECONDS.toSeconds(duration) / 3600L;
            long minutes = TimeUnit.MILLISECONDS.toSeconds(duration - hours * 60L * 60L * 1000L) / 60L;
            long seconds = TimeUnit.MILLISECONDS.toSeconds(duration - minutes * 60L * 1000L);
            long milliseconds = duration - hours * 60L * 60L * 1000L - minutes * 60L * 1000L - seconds * 1000L;
            if (hours > 0L) {
                durationInString.append(hours).append(" hrs ");
            }
            if (minutes > 0L) {
                durationInString.append(minutes).append(" min ");
            }
            if (seconds > 0L) {
                durationInString.append(seconds).append(" sec ");
            }
            if (milliseconds > 0L) {
                durationInString.append(milliseconds).append(" msec");
            }
            return durationInString.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "-1";
        }
    }

    public static String formatLong(long value) {
        if (value == 0L) {
            return "0";
        }
        if (value < 0L) {
            return Long.toString(value);
        }
        return "+" + Long.toString(value);
    }

    public static String escapeString(String str) {
        if (str == null) {
            return "";
        }
        str = str.replace("&", "&amp;");
        str = str.replace("<", "&lt;");
        str = str.replace(">", "&gt;");
        str = str.replace("\"", "&quot;");
        str = str.replace("\n", "<br/>");
        return str;
    }

    public static String formatStackTraceForHTML(String stackTrace) {
        return FormatUtil.escapeString(stackTrace);
    }
}

