/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testng.results;

import hudson.model.AbstractBuild;
import hudson.plugins.testng.results.BaseResult;
import hudson.plugins.testng.results.GroupedTestRun;
import hudson.plugins.testng.results.MethodResult;
import hudson.plugins.testng.results.PackageResult;
import hudson.plugins.testng.results.TestResults;
import hudson.plugins.testng.util.TestResultHistoryUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassResult
extends BaseResult {
    private List<MethodResult> testMethodList = new ArrayList<MethodResult>();
    private Map<String, GroupedTestRun> testRunMap = null;
    private long duration;
    private int fail;
    private int skip;
    private int total;

    public ClassResult(String name) {
        super(name);
    }

    public Map<String, GroupedTestRun> getTestRunMap() {
        if (this.testRunMap != null) {
            return this.testRunMap;
        }
        this.testRunMap = new HashMap<String, GroupedTestRun>();
        for (MethodResult methodResult : this.testMethodList) {
            String methodTestRunId = methodResult.getTestRunId();
            GroupedTestRun group = null;
            if (this.testRunMap.containsKey(methodTestRunId)) {
                group = this.testRunMap.get(methodTestRunId);
            } else {
                group = new GroupedTestRun(methodTestRunId, methodResult.getParentTestName(), methodResult.getParentSuiteName());
                this.testRunMap.put(methodTestRunId, group);
            }
            if (methodResult.isConfig()) {
                group.addConfigurationMethod(methodResult);
                continue;
            }
            group.addTestMethod(methodResult);
        }
        return this.testRunMap;
    }

    @Override
    public void setOwner(AbstractBuild<?, ?> owner) {
        super.setOwner(owner);
        for (MethodResult _m : this.testMethodList) {
            _m.setOwner(owner);
        }
    }

    @Exported
    public long getDuration() {
        return this.duration;
    }

    @Exported(visibility=9)
    public int getFail() {
        return this.fail;
    }

    @Exported(visibility=9)
    public int getSkip() {
        return this.skip;
    }

    @Exported(visibility=9)
    public int getTotal() {
        return this.total;
    }

    public List<MethodResult> getTestMethodList() {
        return this.testMethodList;
    }

    public void addTestMethods(List<MethodResult> list) {
        this.testMethodList.addAll(list);
    }

    public void addTestMethod(MethodResult testMethod) {
        this.testMethodList.add(testMethod);
    }

    public long getFailedTestsDiffCount() {
        ClassResult prevClassResult = this.getPreviousClassResult();
        if (prevClassResult != null) {
            return this.getFail() - prevClassResult.getFail();
        }
        return 0L;
    }

    public long getSkippedTestsDiffCount() {
        ClassResult prevClassResult = this.getPreviousClassResult();
        if (prevClassResult != null) {
            return this.getSkip() - prevClassResult.getSkip();
        }
        return 0L;
    }

    public long getTotalTestsDiffCount() {
        ClassResult prevClassResult = this.getPreviousClassResult();
        if (prevClassResult != null) {
            return this.getTotal() - prevClassResult.getTotal();
        }
        return 0L;
    }

    public void tally() {
        this.duration = 0L;
        this.fail = 0;
        this.skip = 0;
        this.total = 0;
        HashMap<String, Integer> methodInstanceMap = new HashMap<String, Integer>();
        for (MethodResult methodResult : this.testMethodList) {
            if (!methodResult.isConfig()) {
                this.duration += methodResult.getDuration();
                ++this.total;
                if ("FAIL".equals(methodResult.getStatus())) {
                    ++this.fail;
                } else if ("SKIP".equals(methodResult.getStatus())) {
                    ++this.skip;
                }
            }
            methodResult.setParent(this);
            String methodName = methodResult.getName();
            if (methodInstanceMap.containsKey(methodName)) {
                int currIdx = (Integer)methodInstanceMap.get(methodName);
                methodResult.setTestUuid(String.valueOf(++currIdx));
                methodInstanceMap.put(methodName, currIdx);
                continue;
            }
            methodInstanceMap.put(methodName, 0);
        }
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        if (token.equals("/" + this.getName())) {
            return this;
        }
        if (this.testMethodList != null) {
            for (MethodResult methodResult : this.testMethodList) {
                if (!token.equals(methodResult.getUrl())) continue;
                return methodResult;
            }
        }
        return null;
    }

    @Exported(name="test-method")
    public List<MethodResult> getTestMethods() {
        ArrayList<MethodResult> list = new ArrayList<MethodResult>();
        for (MethodResult methodResult : this.testMethodList) {
            if (methodResult.isConfig()) continue;
            list.add(methodResult);
        }
        return list;
    }

    public List<MethodResult> getConfigurationMethods() {
        ArrayList<MethodResult> list = new ArrayList<MethodResult>();
        for (MethodResult methodResult : this.testMethodList) {
            if (!methodResult.isConfig()) continue;
            list.add(methodResult);
        }
        return list;
    }

    public long getAge() {
        ClassResult prevClassResult = this.getPreviousClassResult();
        if (prevClassResult == null) {
            return 1L;
        }
        return 1L + prevClassResult.getAge();
    }

    private ClassResult getPreviousClassResult() {
        String classPackageName;
        TestResults previousTestResults = TestResultHistoryUtil.getPreviousBuildTestResults(this.getOwner());
        Map<String, PackageResult> previousPackageMap = previousTestResults.getPackageMap();
        PackageResult packageResult = previousPackageMap.get(classPackageName = this.getParent().getName());
        if (packageResult != null) {
            List<ClassResult> prevClassList = packageResult.getClassList();
            for (ClassResult prevClassResult : prevClassList) {
                if (!prevClassResult.getName().equals(this.getName())) continue;
                return prevClassResult;
            }
        }
        return null;
    }
}

