/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import com.google.common.collect.Lists;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameterFactory;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameterFactoryDescriptor;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import hudson.plugins.parameterizedtrigger.Messages;
import hudson.plugins.parameterizedtrigger.PredefinedBuildParameters;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBuildParameterFactory
extends AbstractBuildParameterFactory {
    private final String filePattern;

    @DataBoundConstructor
    public FileBuildParameterFactory(String filePattern) {
        this.filePattern = filePattern;
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    @Override
    public List<AbstractBuildParameters> getParameters(AbstractBuild<?, ?> build, TaskListener listener) throws IOException, InterruptedException, AbstractBuildParameters.DontTriggerException {
        ArrayList result = Lists.newArrayList();
        try {
            FilePath[] files;
            FilePath workspace = this.getWorkspace(build);
            for (FilePath f : files = workspace.list(this.getFilePattern())) {
                String parametersStr = f.readToString();
                Logger.getLogger(FileBuildParameterFactory.class.getName()).log(Level.INFO, null, "Triggering build with " + f.getBaseName());
                result.add(new PredefinedBuildParameters(parametersStr));
            }
        }
        catch (Exception ex) {
            Logger.getLogger(FileBuildParameterFactory.class.getName()).log(Level.SEVERE, null, ex);
        }
        return result;
    }

    private FilePath getWorkspace(AbstractBuild build) {
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            workspace = build.getProject().getSomeWorkspace();
        }
        return workspace;
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractBuildParameterFactoryDescriptor {
        public String getDisplayName() {
            return Messages.FileBuildParameterFactory_FileBuildParameterFactory();
        }
    }
}

