/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.AutoCompletionCandidates;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.TaskListener;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameterFactory;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import hudson.plugins.parameterizedtrigger.ResultCondition;
import hudson.tasks.Messages;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.concurrent.Future;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildTriggerConfig
implements Describable<BuildTriggerConfig> {
    private final List<AbstractBuildParameters> configs;
    private final List<AbstractBuildParameterFactory> configFactories;
    private String projects;
    private final ResultCondition condition;
    private boolean triggerWithNoParameters;

    public BuildTriggerConfig(String projects, ResultCondition condition, boolean triggerWithNoParameters, List<AbstractBuildParameterFactory> configFactories, List<AbstractBuildParameters> configs) {
        this.projects = projects;
        this.condition = condition;
        this.triggerWithNoParameters = triggerWithNoParameters;
        this.configFactories = configFactories;
        this.configs = Util.fixNull(configs);
    }

    @DataBoundConstructor
    public BuildTriggerConfig(String projects, ResultCondition condition, boolean triggerWithNoParameters, List<AbstractBuildParameters> configs) {
        this(projects, condition, triggerWithNoParameters, null, configs);
    }

    public BuildTriggerConfig(String projects, ResultCondition condition, AbstractBuildParameters ... configs) {
        this(projects, condition, false, null, Arrays.asList(configs));
    }

    public BuildTriggerConfig(String projects, ResultCondition condition, List<AbstractBuildParameterFactory> configFactories, AbstractBuildParameters ... configs) {
        this(projects, condition, false, configFactories, Arrays.asList(configs));
    }

    public List<AbstractBuildParameters> getConfigs() {
        return this.configs;
    }

    public List<AbstractBuildParameterFactory> getConfigFactories() {
        return this.configFactories;
    }

    public String getProjects() {
        return this.projects;
    }

    public ResultCondition getCondition() {
        return this.condition;
    }

    public boolean getTriggerWithNoParameters() {
        return this.triggerWithNoParameters;
    }

    public List<AbstractProject> getProjectList(EnvVars env) {
        return this.getProjectList(null, env);
    }

    public List<AbstractProject> getProjectList(ItemGroup context, EnvVars env) {
        ArrayList<AbstractProject> projectList = new ArrayList<AbstractProject>();
        StringBuilder projectNames = new StringBuilder();
        StringTokenizer tokens = new StringTokenizer(this.projects, ",");
        while (tokens.hasMoreTokens()) {
            if (projectNames.length() > 0) {
                projectNames.append(',');
            }
            projectNames.append(env != null ? env.expand(tokens.nextToken().trim()) : tokens.nextToken().trim());
        }
        projectList.addAll(Items.fromNameList((String)projectNames.toString(), AbstractProject.class));
        return projectList;
    }

    private static ParametersAction mergeParameters(ParametersAction base, ParametersAction overlay) {
        LinkedHashMap<String, ParameterValue> params = new LinkedHashMap<String, ParameterValue>();
        for (ParameterValue param : base.getParameters()) {
            params.put(param.getName(), param);
        }
        for (ParameterValue param : overlay.getParameters()) {
            params.put(param.getName(), param);
        }
        return new ParametersAction(params.values().toArray(new ParameterValue[params.size()]));
    }

    private static ParametersAction getDefaultParameters(AbstractProject<?, ?> project) {
        ParametersDefinitionProperty property = (ParametersDefinitionProperty)project.getProperty(ParametersDefinitionProperty.class);
        if (property == null) {
            return null;
        }
        ArrayList<ParameterValue> parameters = new ArrayList<ParameterValue>();
        for (ParameterDefinition pd : property.getParameterDefinitions()) {
            ParameterValue param = pd.getDefaultParameterValue();
            if (param == null) continue;
            parameters.add(param);
        }
        return new ParametersAction(parameters);
    }

    List<Action> getBaseActions(AbstractBuild<?, ?> build, TaskListener listener) throws IOException, InterruptedException, AbstractBuildParameters.DontTriggerException {
        return this.getBaseActions(this.configs, build, listener);
    }

    List<Action> getBaseActions(Collection<AbstractBuildParameters> configs, AbstractBuild<?, ?> build, TaskListener listener) throws IOException, InterruptedException, AbstractBuildParameters.DontTriggerException {
        ArrayList<Action> actions = new ArrayList<Action>();
        ParametersAction params = null;
        for (AbstractBuildParameters config : configs) {
            Action a = config.getAction(build, listener);
            if (a instanceof ParametersAction) {
                params = params == null ? (ParametersAction)a : BuildTriggerConfig.mergeParameters(params, (ParametersAction)a);
                continue;
            }
            if (a == null) continue;
            actions.add(a);
        }
        if (params != null) {
            actions.add((Action)params);
        }
        return actions;
    }

    List<Action> getBuildActions(List<Action> baseActions, AbstractProject project) {
        ArrayList<Action> actions = new ArrayList<Action>(baseActions);
        ParametersAction defaultParameters = BuildTriggerConfig.getDefaultParameters(project);
        if (defaultParameters != null) {
            Action a = null;
            ListIterator<ParametersAction> it = actions.listIterator();
            while (it.hasNext()) {
                a = (Action)it.next();
                if (!(a instanceof ParametersAction)) continue;
                it.set(BuildTriggerConfig.mergeParameters(defaultParameters, (ParametersAction)a));
                break;
            }
            if (!(a instanceof ParametersAction)) {
                actions.add((Action)defaultParameters);
            }
        }
        return actions;
    }

    public List<Future<AbstractBuild>> perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        EnvVars env = build.getEnvironment((TaskListener)listener);
        env.overrideAll(build.getBuildVariables());
        try {
            if (this.condition.isMet(build.getResult())) {
                ArrayList<Future<AbstractBuild>> futures = new ArrayList<Future<AbstractBuild>>();
                for (List<AbstractBuildParameters> addConfigs : this.getDynamicBuildParameters(build, listener)) {
                    List<Action> actions = this.getBaseActions((Collection<AbstractBuildParameters>)ImmutableList.builder().addAll(this.configs).addAll(addConfigs).build(), build, (TaskListener)listener);
                    for (AbstractProject project : this.getProjectList(build.getProject().getParent(), env)) {
                        List<Action> list = this.getBuildActions(actions, project);
                        futures.add(this.schedule(build, project, list));
                    }
                }
                return futures;
            }
        }
        catch (AbstractBuildParameters.DontTriggerException e) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    public ListMultimap<AbstractProject, Future<AbstractBuild>> perform2(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        EnvVars env = build.getEnvironment((TaskListener)listener);
        env.overrideAll(build.getBuildVariables());
        try {
            if (this.getCondition().isMet(build.getResult())) {
                ArrayListMultimap futures = ArrayListMultimap.create();
                for (List<AbstractBuildParameters> addConfigs : this.getDynamicBuildParameters(build, listener)) {
                    List<Action> actions = this.getBaseActions((Collection<AbstractBuildParameters>)ImmutableList.builder().addAll(this.configs).addAll(addConfigs).build(), build, (TaskListener)listener);
                    for (AbstractProject project : this.getProjectList(build.getProject().getParent(), env)) {
                        List<Action> list = this.getBuildActions(actions, project);
                        futures.put((Object)project, (Object)this.schedule(build, project, list));
                    }
                }
                return futures;
            }
        }
        catch (AbstractBuildParameters.DontTriggerException e) {
            // empty catch block
        }
        return ArrayListMultimap.create();
    }

    private List<List<AbstractBuildParameters>> getDynamicBuildParameters(AbstractBuild<?, ?> build, BuildListener listener) throws AbstractBuildParameters.DontTriggerException, IOException, InterruptedException {
        if (this.configFactories == null || this.configFactories.isEmpty()) {
            return ImmutableList.of((Object)ImmutableList.of());
        }
        ArrayList dynamicBuildParameters = Lists.newArrayList();
        dynamicBuildParameters.add(Collections.emptyList());
        for (AbstractBuildParameterFactory configFactory : this.configFactories) {
            ArrayList newDynParameters = Lists.newArrayList();
            for (AbstractBuildParameters config : configFactory.getParameters(build, (TaskListener)listener)) {
                for (List dynamicBuildParameter : dynamicBuildParameters) {
                    newDynParameters.add(ImmutableList.builder().addAll((Iterable)dynamicBuildParameter).add((Object)config).build());
                }
            }
            dynamicBuildParameters = newDynParameters;
        }
        return dynamicBuildParameters;
    }

    protected Future schedule(AbstractBuild<?, ?> build, AbstractProject project, List<Action> list) throws InterruptedException, IOException {
        return project.scheduleBuild2(project.getQuietPeriod(), (Cause)new Cause.UpstreamCause(build), list.toArray(new Action[list.size()]));
    }

    public boolean onJobRenamed(String oldName, String newName) {
        boolean changed = false;
        String[] list = this.projects.split(",");
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].trim().equals(oldName)) continue;
            list[i] = newName;
            changed = true;
        }
        if (changed) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < list.length; ++i) {
                if (list[i] == null) continue;
                if (buf.length() > 0) {
                    buf.append(',');
                }
                buf.append(list[i]);
            }
            this.projects = buf.toString();
        }
        return changed;
    }

    public boolean onDeleted(String oldName) {
        return this.onJobRenamed(oldName, null);
    }

    public Descriptor<BuildTriggerConfig> getDescriptor() {
        return Hudson.getInstance().getDescriptorOrDie(this.getClass());
    }

    public String toString() {
        return this.getClass().getName() + " [projects=" + this.projects + ", condition=" + (Object)((Object)this.condition) + ", configs=" + this.configs + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<BuildTriggerConfig> {
        public String getDisplayName() {
            return "";
        }

        public List<Descriptor<AbstractBuildParameters>> getBuilderConfigDescriptors() {
            return Hudson.getInstance().getDescriptorList(AbstractBuildParameters.class);
        }

        public List<Descriptor<AbstractBuildParameterFactory>> getBuilderConfigFactoryDescriptors() {
            return Hudson.getInstance().getDescriptorList(AbstractBuildParameterFactory.class);
        }

        public FormValidation doCheckProjects(@AncestorInPath Item project, @QueryParameter String value) {
            if (!project.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            StringTokenizer tokens = new StringTokenizer(Util.fixNull((String)value), ",");
            boolean hasProjects = false;
            while (tokens.hasMoreTokens()) {
                String projectName = tokens.nextToken().trim();
                if (!StringUtils.isNotBlank((String)projectName)) continue;
                Item item = Hudson.getInstance().getItemByFullName(projectName);
                if (item == null) {
                    return FormValidation.error((String)Messages.BuildTrigger_NoSuchProject((Object)projectName, (Object)AbstractProject.findNearest((String)projectName).getName()));
                }
                if (!(item instanceof AbstractProject)) {
                    return FormValidation.error((String)Messages.BuildTrigger_NotBuildable((Object)projectName));
                }
                hasProjects = true;
            }
            if (!hasProjects) {
                return FormValidation.error((String)"No project specified");
            }
            return FormValidation.ok();
        }

        public AutoCompletionCandidates doAutoCompleteProjects(@QueryParameter String value) {
            AutoCompletionCandidates candidates = new AutoCompletionCandidates();
            List jobs = Hudson.getInstance().getItems(Job.class);
            for (Job job : jobs) {
                if (!job.getFullName().startsWith(value) || !job.hasPermission(Item.READ)) continue;
                candidates.add(job.getFullName());
            }
            return candidates;
        }
    }
}

