/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.DependecyDeclarer;
import hudson.model.DependencyGraph;
import hudson.model.TaskListener;
import hudson.plugins.parameterizedtrigger.BuildTriggerConfig;
import hudson.plugins.parameterizedtrigger.CapturedEnvironmentAction;
import hudson.plugins.parameterizedtrigger.ParameterizedDependency;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildTrigger
extends Notifier
implements DependecyDeclarer,
MatrixAggregatable {
    private final ArrayList<BuildTriggerConfig> configs;

    @DataBoundConstructor
    public BuildTrigger(List<BuildTriggerConfig> configs) {
        this.configs = new ArrayList(Util.fixNull(configs));
    }

    public BuildTrigger(BuildTriggerConfig ... configs) {
        this(Arrays.asList(configs));
    }

    public List<BuildTriggerConfig> getConfigs() {
        return this.configs;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (this.canDeclare(build.getProject())) {
            EnvVars env = build.getEnvironment((TaskListener)listener);
            build.addAction((Action)new CapturedEnvironmentAction(env));
        } else {
            for (BuildTriggerConfig config : this.configs) {
                config.perform(build, launcher, listener);
            }
        }
        return true;
    }

    private boolean canDeclare(AbstractProject owner) {
        String ownerClassName = owner.getClass().getName();
        return DependencyGraph.class.getClasses().length > 0 && !ownerClassName.equals("hudson.plugins.promoted_builds.PromotionProcess");
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        return new MatrixAggregator(build, launcher, listener){

            public boolean endBuild() throws InterruptedException, IOException {
                return hudson.tasks.BuildTrigger.execute((AbstractBuild)this.build, (BuildListener)this.listener);
            }
        };
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public void buildDependencyGraph(AbstractProject owner, DependencyGraph graph) {
        if (!this.canDeclare(owner)) {
            return;
        }
        for (BuildTriggerConfig config : this.configs) {
            for (AbstractProject project : config.getProjectList(owner.getParent(), null)) {
                ParameterizedDependency.add(owner, project, config, graph);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return "Trigger parameterized build on other projects";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

